/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DependencyRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DependencyVariableNamer {
    private static final Pattern LAZY_PROVIDER_PATTERN = Pattern.compile("lazy(\\w+)Provider");

    DependencyVariableNamer() {
    }

    static String name(DependencyRequest dependency) {
        if (!dependency.requestElement().isPresent()) {
            return SourceFiles.simpleVariableName(MoreTypes.asTypeElement(dependency.key().type().java()));
        }
        String variableName = ((DaggerElement)dependency.requestElement().get()).java().getSimpleName().toString();
        if (Ascii.isUpperCase((char)variableName.charAt(0))) {
            variableName = DependencyVariableNamer.toLowerCamel(variableName);
        }
        switch (dependency.kind()) {
            case INSTANCE: {
                return variableName;
            }
            case LAZY: {
                return variableName.startsWith("lazy") && !variableName.equals("lazy") ? DependencyVariableNamer.toLowerCamel(variableName.substring(4)) : variableName;
            }
            case PROVIDER_OF_LAZY: {
                Matcher matcher = LAZY_PROVIDER_PATTERN.matcher(variableName);
                if (matcher.matches()) {
                    return DependencyVariableNamer.toLowerCamel(matcher.group(1));
                }
            }
            case PROVIDER: {
                return variableName.endsWith("Provider") && !variableName.equals("Provider") ? variableName.substring(0, variableName.length() - 8) : variableName;
            }
            case PRODUCED: {
                return variableName.startsWith("produced") && !variableName.equals("produced") ? DependencyVariableNamer.toLowerCamel(variableName.substring(8)) : variableName;
            }
            case PRODUCER: {
                return variableName.endsWith("Producer") && !variableName.equals("Producer") ? variableName.substring(0, variableName.length() - 8) : variableName;
            }
        }
        throw new AssertionError();
    }

    private static String toLowerCamel(String name2) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, name2);
    }
}

