/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.Scope;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public abstract class Binding
extends BindingDeclaration {
    private final Supplier<ImmutableSet<DependencyRequest>> dependencies = Suppliers.memoize(() -> {
        ImmutableSet<DependencyRequest> implicitDependencies = this.implicitDependencies();
        return ImmutableSet.copyOf(implicitDependencies.isEmpty() ? this.explicitDependencies() : Sets.union(implicitDependencies, this.explicitDependencies()));
    });

    public boolean requiresModuleInstance() {
        if (!this.bindingElement().isPresent() || !this.contributingModule().isPresent()) {
            return false;
        }
        Set<Modifier> modifiers = this.bindingElement().get().getModifiers();
        return !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC);
    }

    public abstract boolean isNullable();

    public abstract BindingKind kind();

    public abstract BindingType bindingType();

    public final FrameworkType frameworkType() {
        return FrameworkType.forBindingType(this.bindingType());
    }

    public abstract ImmutableSet<DependencyRequest> explicitDependencies();

    public ImmutableSet<DependencyRequest> implicitDependencies() {
        return ImmutableSet.of();
    }

    public final ImmutableSet<DependencyRequest> dependencies() {
        return (ImmutableSet)this.dependencies.get();
    }

    public abstract Optional<? extends Binding> unresolved();

    public Optional<Scope> scope() {
        return Optional.empty();
    }

    static boolean hasNonDefaultTypeParameters(TypeElement element, TypeMirror type2, DaggerTypes types) {
        ImmutableList actualTypes;
        if (element.getTypeParameters().isEmpty()) {
            return false;
        }
        ImmutableList defaultTypes = (ImmutableList)element.getTypeParameters().stream().map(Element::asType).collect(DaggerStreams.toImmutableList());
        ImmutableList immutableList = actualTypes = type2.getKind() == TypeKind.DECLARED ? ImmutableList.copyOf(MoreTypes.asDeclared(type2).getTypeArguments()) : ImmutableList.of();
        if (defaultTypes.size() != actualTypes.size()) {
            return true;
        }
        for (int i = 0; i < defaultTypes.size(); ++i) {
            if (types.isSameType((TypeMirror)defaultTypes.get(i), (TypeMirror)actualTypes.get(i))) continue;
            return true;
        }
        return false;
    }
}

