/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.MapKeys;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.MapKeyValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.writing.AnnotationCreatorGenerator;
import dagger.internal.codegen.writing.UnwrappedMapKeyGenerator;
import dagger.shaded.androidx.room.compiler.processing.XAnnotationKt;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreTypes;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class MapKeyProcessingStep
extends TypeCheckingProcessingStep<XTypeElement> {
    private final XMessager messager;
    private final DaggerTypes types;
    private final MapKeyValidator mapKeyValidator;
    private final AnnotationCreatorGenerator annotationCreatorGenerator;
    private final UnwrappedMapKeyGenerator unwrappedMapKeyGenerator;

    @Inject
    MapKeyProcessingStep(XMessager messager2, DaggerTypes types, MapKeyValidator mapKeyValidator, AnnotationCreatorGenerator annotationCreatorGenerator, UnwrappedMapKeyGenerator unwrappedMapKeyGenerator) {
        this.messager = messager2;
        this.types = types;
        this.mapKeyValidator = mapKeyValidator;
        this.annotationCreatorGenerator = annotationCreatorGenerator;
        this.unwrappedMapKeyGenerator = unwrappedMapKeyGenerator;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.MAP_KEY);
    }

    @Override
    protected void process(XTypeElement mapAnnotation, ImmutableSet<ClassName> annotations2) {
        ValidationReport mapKeyReport = this.mapKeyValidator.validate(mapAnnotation);
        mapKeyReport.printMessagesTo(this.messager);
        if (mapKeyReport.isClean()) {
            if (!XAnnotationKt.get(mapAnnotation.getAnnotation(TypeNames.MAP_KEY), "unwrapValue", Boolean.class).booleanValue()) {
                this.annotationCreatorGenerator.generate(mapAnnotation, this.messager);
            } else if (this.unwrappedValueKind(XConverters.toJavac(mapAnnotation)).equals((Object)ElementKind.ANNOTATION_TYPE)) {
                this.unwrappedMapKeyGenerator.generate(mapAnnotation, this.messager);
            }
        }
    }

    private ElementKind unwrappedValueKind(TypeElement mapKeyAnnotationType) {
        DeclaredType unwrappedMapKeyType = MapKeys.getUnwrappedMapKeyType(MoreTypes.asDeclared(mapKeyAnnotationType.asType()), this.types);
        return unwrappedMapKeyType.asElement().getKind();
    }
}

