/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.androidx.room.compiler.processing.XMessager;
import dagger.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class AssistedProcessingStep
extends TypeCheckingProcessingStep<XVariableElement> {
    private final KotlinMetadataUtil kotlinMetadataUtil;
    private final InjectionAnnotations injectionAnnotations;
    private final DaggerElements elements;
    private final XMessager messager;
    private final XProcessingEnv processingEnv;

    @Inject
    AssistedProcessingStep(KotlinMetadataUtil kotlinMetadataUtil, InjectionAnnotations injectionAnnotations, DaggerElements elements, XMessager messager2, XProcessingEnv processingEnv) {
        this.kotlinMetadataUtil = kotlinMetadataUtil;
        this.injectionAnnotations = injectionAnnotations;
        this.elements = elements;
        this.messager = messager2;
        this.processingEnv = processingEnv;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.ASSISTED);
    }

    @Override
    protected void process(XVariableElement assisted, ImmutableSet<ClassName> annotations2) {
        new AssistedValidator().validate(assisted).printMessagesTo(this.messager);
    }

    private boolean isAssistedInjectConstructor(Element element) {
        return element.getKind() == ElementKind.CONSTRUCTOR && MoreElements.isAnnotationPresent(element, AssistedInject.class);
    }

    private boolean isAssistedFactoryCreateMethod(Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            TypeElement enclosingElement2 = DaggerElements.closestEnclosingTypeElement(element);
            return AssistedInjectionAnnotations.isAssistedFactoryType(enclosingElement2) && AssistedInjectionAnnotations.assistedFactoryMethod(enclosingElement2, this.elements).equals(element);
        }
        return false;
    }

    private boolean isKotlinDataClassCopyMethod(Element element) {
        return element.getKind() == ElementKind.METHOD && element.getSimpleName().contentEquals("copy") && this.kotlinMetadataUtil.isDataClass(DaggerElements.closestEnclosingTypeElement(element));
    }

    private final class AssistedValidator {
        private AssistedValidator() {
        }

        ValidationReport validate(XVariableElement assisted) {
            ValidationReport.Builder report = ValidationReport.about(assisted);
            VariableElement javaAssisted = XConverters.toJavac(assisted);
            Element enclosingElement2 = javaAssisted.getEnclosingElement();
            if (!(AssistedProcessingStep.this.isAssistedInjectConstructor(enclosingElement2) || AssistedProcessingStep.this.isAssistedFactoryCreateMethod(enclosingElement2) || AssistedProcessingStep.this.isKotlinDataClassCopyMethod(enclosingElement2))) {
                report.addError("@Assisted parameters can only be used within an @AssistedInject-annotated constructor.", assisted);
            }
            AssistedProcessingStep.this.injectionAnnotations.getQualifiers(javaAssisted).forEach(qualifier -> report.addError("Qualifiers cannot be used with @Assisted parameters.", assisted, XConverters.toXProcessing(qualifier, AssistedProcessingStep.this.processingEnv)));
            return report.build();
        }
    }
}

