/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.producers.Producer;
import dagger.producers.internal.Producers;
import dagger.spi.model.RequestKind;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class ProducerEntryPointView {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final DaggerTypes types;

    ProducerEntryPointView(ComponentImplementation.ShardImplementation shardImplementation, DaggerTypes types) {
        this.shardImplementation = shardImplementation;
        this.types = types;
    }

    Optional<Expression> getProducerEntryPointField(BindingExpression producerExpression, ComponentDescriptor.ComponentMethodDescriptor componentMethod, ClassName requestingClass) {
        if (this.shardImplementation.componentDescriptor().isProduction() && (componentMethod.dependencyRequest().get().kind().equals((Object)RequestKind.FUTURE) || componentMethod.dependencyRequest().get().kind().equals((Object)RequestKind.PRODUCER))) {
            MemberSelect field = this.createField(producerExpression, componentMethod);
            return Optional.of(Expression.create(this.fieldType(componentMethod), field.getExpressionFor(requestingClass)));
        }
        return Optional.empty();
    }

    private MemberSelect createField(BindingExpression producerExpression, ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        String methodName = componentMethod.methodElement().getSimpleName().toString();
        FieldSpec field = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)this.fieldType(componentMethod)), (String)this.shardImplementation.getUniqueFieldName(methodName + "EntryPoint"), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
        this.shardImplementation.addField(ComponentImplementation.FieldSpecKind.FRAMEWORK_FIELD, field);
        CodeBlock fieldInitialization = CodeBlock.of((String)"this.$N = $T.entryPointViewOf($L, $L);", (Object[])new Object[]{field, Producers.class, producerExpression.getDependencyExpression(this.shardImplementation.name()).codeBlock(), this.shardImplementation.isComponentShard() ? "this" : this.shardImplementation.getComponentImplementation().getComponentShard().shardFieldReference()});
        this.shardImplementation.addInitialization(fieldInitialization);
        return MemberSelect.localField(this.shardImplementation, field.name);
    }

    private TypeMirror fieldType(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        return this.types.wrapType(componentMethod.dependencyRequest().get().key().type().java(), Producer.class);
    }
}

