/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.MemberSelect;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

abstract class FrameworkInstanceBindingExpression
extends BindingExpression {
    private final ContributionBinding binding;
    private final FrameworkInstanceSupplier frameworkInstanceSupplier;
    private final DaggerTypes types;
    private final DaggerElements elements;

    FrameworkInstanceBindingExpression(ContributionBinding binding, FrameworkInstanceSupplier frameworkInstanceSupplier, DaggerTypes types, DaggerElements elements) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.frameworkInstanceSupplier = (FrameworkInstanceSupplier)Preconditions.checkNotNull((Object)frameworkInstanceSupplier);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        MemberSelect memberSelect = this.frameworkInstanceSupplier.memberSelect();
        DeclaredType expressionType = Accessibility.isTypeAccessibleFrom(this.binding.contributedType(), requestingClass.packageName()) || FrameworkInstanceBindingExpression.isInlinedFactoryCreation(memberSelect) ? this.types.wrapType(this.binding.contributedType(), this.frameworkType().frameworkClass()) : this.rawFrameworkType();
        return Expression.create(expressionType, memberSelect.getExpressionFor(requestingClass));
    }

    protected abstract FrameworkType frameworkType();

    private static boolean isInlinedFactoryCreation(MemberSelect memberSelect) {
        return memberSelect.staticMember();
    }

    private DeclaredType rawFrameworkType() {
        return this.types.getDeclaredType(this.elements.getTypeElement(this.frameworkType().frameworkClass()), new TypeMirror[0]);
    }
}

