/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.AssistedPrivateMethodBindingExpression;
import dagger.internal.codegen.writing.ComponentBindingExpressions;
import dagger.internal.codegen.writing.SimpleInvocationBindingExpression;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.model.DependencyRequest;
import dagger.spi.model.RequestKind;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class AssistedFactoryBindingExpression
extends SimpleInvocationBindingExpression {
    private final ProvisionBinding binding;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerElements elements;
    private final DaggerTypes types;

    @AssistedInject
    AssistedFactoryBindingExpression(@Assisted ProvisionBinding binding, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, DaggerElements elements) {
        super(binding);
        this.binding = (ProvisionBinding)Preconditions.checkNotNull((Object)binding);
        this.componentBindingExpressions = componentBindingExpressions;
        this.elements = elements;
        this.types = types;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        DependencyRequest assistedInjectionRequest = (DependencyRequest)Iterables.getOnlyElement(this.binding.provisionDependencies());
        Expression assistedInjectionExpression = ((AssistedPrivateMethodBindingExpression)this.componentBindingExpressions.getBindingExpression(BindingRequest.bindingRequest(assistedInjectionRequest.key(), RequestKind.INSTANCE))).getAssistedDependencyExpression(requestingClass.peerClass(""));
        return Expression.create(assistedInjectionExpression.type(), CodeBlock.of((String)"$L", (Object[])new Object[]{this.anonymousfactoryImpl(assistedInjectionExpression)}));
    }

    private TypeSpec anonymousfactoryImpl(Expression assistedInjectionExpression) {
        TypeElement factory = MoreElements.asType(this.binding.bindingElement().get());
        DeclaredType factoryType = MoreTypes.asDeclared(this.binding.key().type().java());
        ExecutableElement factoryMethod = AssistedInjectionAnnotations.assistedFactoryMethod(factory, this.elements);
        MethodSpec factoryOverride = MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)factoryType, (Types)this.types).build();
        TypeSpec.Builder builder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addMethod(MethodSpec.methodBuilder((String)factoryMethod.getSimpleName().toString()).addModifiers((Iterable)factoryOverride.modifiers).addTypeVariables((Iterable)factoryOverride.typeVariables).returns(factoryOverride.returnType).addAnnotations((Iterable)factoryOverride.annotations).addExceptions((Iterable)factoryOverride.exceptions).addParameters(AssistedInjectionAnnotations.assistedFactoryParameterSpecs(this.binding, this.elements, this.types)).addStatement("return $L", new Object[]{assistedInjectionExpression.codeBlock()}).build());
        if (factory.getKind() == ElementKind.INTERFACE) {
            builder.addSuperinterface(TypeName.get((TypeMirror)factoryType));
        } else {
            builder.superclass(TypeName.get((TypeMirror)factoryType));
        }
        return builder.build();
    }

    @AssistedFactory
    static interface Factory {
        public AssistedFactoryBindingExpression create(ProvisionBinding var1);
    }
}

