/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.compileroption.ProcessingOptions;
import dagger.internal.codegen.compileroption.ValidationType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.DiagnosticReporterFactory;
import dagger.internal.codegen.validation.Validation;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.DiagnosticReporter;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public final class ValidationBindingGraphPlugins {
    private final ImmutableSet<BindingGraphPlugin> plugins;
    private final DiagnosticReporterFactory diagnosticReporterFactory;
    private final Filer filer;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final CompilerOptions compilerOptions;
    private final Map<String, String> processingOptions;

    @Inject
    ValidationBindingGraphPlugins(@Validation ImmutableSet<BindingGraphPlugin> plugins, DiagnosticReporterFactory diagnosticReporterFactory, Filer filer, DaggerTypes types, DaggerElements elements, CompilerOptions compilerOptions, @ProcessingOptions Map<String, String> processingOptions) {
        this.plugins = plugins;
        this.diagnosticReporterFactory = diagnosticReporterFactory;
        this.filer = filer;
        this.types = types;
        this.elements = elements;
        this.compilerOptions = compilerOptions;
        this.processingOptions = processingOptions;
    }

    public ImmutableSet<String> allSupportedOptions() {
        return (ImmutableSet)this.plugins.stream().flatMap(plugin -> plugin.supportedOptions().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public void initializePlugins() {
        this.plugins.forEach(this::initializePlugin);
    }

    private void initializePlugin(BindingGraphPlugin plugin) {
        plugin.initFiler(this.filer);
        plugin.initTypes((Types)this.types);
        plugin.initElements((Elements)this.elements);
        Set supportedOptions = plugin.supportedOptions();
        if (!supportedOptions.isEmpty()) {
            plugin.initOptions(Maps.filterKeys(this.processingOptions, supportedOptions::contains));
        }
    }

    boolean visit(BindingGraph graph) {
        boolean errorsAsWarnings = graph.isFullBindingGraph() && this.compilerOptions.fullBindingGraphValidationType().equals((Object)ValidationType.WARNING);
        boolean isClean = true;
        for (BindingGraphPlugin plugin : this.plugins) {
            DiagnosticReporterFactory.DiagnosticReporterImpl reporter = this.diagnosticReporterFactory.reporter(graph, plugin.pluginName(), errorsAsWarnings);
            plugin.visitGraph(graph, (DiagnosticReporter)reporter);
            if (!reporter.reportedDiagnosticKinds().contains((Object)Diagnostic.Kind.ERROR)) continue;
            isClean = false;
        }
        return isClean;
    }
}

