/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;

final class MembersInjectionValidator {
    private final InjectionAnnotations injectionAnnotations;
    private static final TypeVisitor<Void, ValidationReport.Builder<?>> VALIDATE_MEMBERS_INJECTED_TYPE = new SimpleTypeVisitor8<Void, ValidationReport.Builder<?>>(){

        @Override
        protected Void defaultAction(TypeMirror type2, ValidationReport.Builder<?> report) {
            report.addError("Cannot inject members into " + type2);
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType type2, ValidationReport.Builder<?> report) {
            if (type2.getTypeArguments().isEmpty()) {
                if (!MoreElements.asType(type2.asElement()).getTypeParameters().isEmpty()) {
                    report.addError("Cannot inject members into raw type " + type2);
                }
            } else {
                for (TypeMirror typeMirror : type2.getTypeArguments()) {
                    if (((Boolean)typeMirror.accept(DECLARED_OR_ARRAY, null)).booleanValue()) continue;
                    report.addError("Cannot inject members into types with unbounded type arguments: " + type2);
                }
            }
            return null;
        }
    };
    private static final TypeVisitor<Boolean, Void> DECLARED_OR_ARRAY = new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

        @Override
        public Boolean visitArray(ArrayType arrayType, Void p) {
            return arrayType.getComponentType().accept(new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

                @Override
                public Boolean visitDeclared(DeclaredType declaredType, Void p) {
                    for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                        if (typeMirror.accept(this, null).booleanValue()) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public Boolean visitArray(ArrayType arrayType, Void p) {
                    return arrayType.getComponentType().accept(this, null);
                }

                @Override
                public Boolean visitPrimitive(PrimitiveType primitiveType, Void p) {
                    return true;
                }
            }, null);
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            return true;
        }
    };

    @Inject
    MembersInjectionValidator(InjectionAnnotations injectionAnnotations) {
        this.injectionAnnotations = injectionAnnotations;
    }

    ValidationReport<Element> validateMembersInjectionRequest(Element requestElement, TypeMirror membersInjectedType) {
        ValidationReport.Builder<Element> report = ValidationReport.about(requestElement);
        this.checkQualifiers(report, requestElement);
        membersInjectedType.accept(VALIDATE_MEMBERS_INJECTED_TYPE, report);
        return report.build();
    }

    ValidationReport<ExecutableElement> validateMembersInjectionMethod(ExecutableElement method, TypeMirror membersInjectedType) {
        Preconditions.checkArgument((method.getParameters().size() == 1 ? 1 : 0) != 0, (String)"expected a method with one parameter: %s", (Object)method);
        ValidationReport.Builder<ExecutableElement> report = ValidationReport.about(method);
        this.checkQualifiers(report, method);
        this.checkQualifiers(report, method.getParameters().get(0));
        membersInjectedType.accept(VALIDATE_MEMBERS_INJECTED_TYPE, report);
        return report.build();
    }

    private void checkQualifiers(ValidationReport.Builder<?> report, Element element) {
        block0: {
            UnmodifiableIterator unmodifiableIterator = this.injectionAnnotations.getQualifiers(element).iterator();
            if (!unmodifiableIterator.hasNext()) break block0;
            AnnotationMirror qualifier = (AnnotationMirror)unmodifiableIterator.next();
            report.addError("Cannot inject members into qualified types", element, qualifier);
        }
    }
}

