/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.validation.BindsInstanceMethodValidator;
import dagger.internal.codegen.validation.BindsInstanceParameterValidator;
import dagger.internal.codegen.validation.XTypeCheckingProcessingStep;
import dagger.shaded.androidx.room.compiler.processing.XElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;

public final class BindsInstanceProcessingStep
extends XTypeCheckingProcessingStep<XElement> {
    private final BindsInstanceMethodValidator methodValidator;
    private final BindsInstanceParameterValidator parameterValidator;
    private final Messager messager;

    @Inject
    BindsInstanceProcessingStep(BindsInstanceMethodValidator methodValidator, BindsInstanceParameterValidator parameterValidator, Messager messager2) {
        this.methodValidator = methodValidator;
        this.parameterValidator = parameterValidator;
        this.messager = messager2;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.BINDS_INSTANCE);
    }

    @Override
    protected void process(XElement xElement, ImmutableSet<ClassName> annotations2) {
        Element element = XConverters.toJavac(xElement);
        switch (element.getKind()) {
            case PARAMETER: {
                this.parameterValidator.validate(MoreElements.asVariable(element)).printMessagesTo(this.messager);
                break;
            }
            case METHOD: {
                this.methodValidator.validate(MoreElements.asExecutable(element)).printMessagesTo(this.messager);
                break;
            }
            default: {
                throw new AssertionError(element);
            }
        }
    }
}

