/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.base.DiagnosticFormatting;
import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

public final class MethodSignatureFormatter
extends Formatter<ExecutableElement> {
    private final DaggerTypes types;
    private final InjectionAnnotations injectionAnnotations;

    @Inject
    public MethodSignatureFormatter(DaggerTypes types, InjectionAnnotations injectionAnnotations) {
        this.types = types;
        this.injectionAnnotations = injectionAnnotations;
    }

    public Formatter<ExecutableElement> typedFormatter(final DeclaredType declaredType) {
        return new Formatter<ExecutableElement>(){

            @Override
            public String format(ExecutableElement method) {
                return MethodSignatureFormatter.this.format(method, MoreTypes.asExecutable(MethodSignatureFormatter.this.types.asMemberOf(declaredType, method)), MoreElements.asType(method.getEnclosingElement()));
            }
        };
    }

    @Override
    public String format(ExecutableElement method) {
        return this.format(method, Optional.empty());
    }

    public String format(ExecutableElement method, Optional<DeclaredType> container) {
        TypeElement type2 = MoreElements.asType(method.getEnclosingElement());
        ExecutableType executableType2 = MoreTypes.asExecutable(method.asType());
        if (container.isPresent()) {
            executableType2 = MoreTypes.asExecutable(this.types.asMemberOf(container.get(), method));
            type2 = MoreElements.asType(container.get().asElement());
        }
        return this.format(method, executableType2, type2);
    }

    private String format(ExecutableElement method, ExecutableType methodType, TypeElement declaringType) {
        StringBuilder builder = new StringBuilder();
        List<? extends AnnotationMirror> annotations2 = method.getAnnotationMirrors();
        if (!annotations2.isEmpty()) {
            Iterator<? extends AnnotationMirror> annotationIterator = annotations2.iterator();
            int i = 0;
            while (annotationIterator.hasNext()) {
                if (i > 0) {
                    builder.append(' ');
                }
                builder.append(MethodSignatureFormatter.formatAnnotation(annotationIterator.next()));
                ++i;
            }
            builder.append(' ');
        }
        if (method.getSimpleName().contentEquals("<init>")) {
            builder.append(declaringType.getQualifiedName());
        } else {
            builder.append(MethodSignatureFormatter.nameOfType(methodType.getReturnType())).append(' ').append(declaringType.getQualifiedName()).append('.').append(method.getSimpleName());
        }
        builder.append('(');
        Preconditions.checkState((method.getParameters().size() == methodType.getParameterTypes().size() ? 1 : 0) != 0);
        Iterator<? extends VariableElement> parameters2 = method.getParameters().iterator();
        Iterator<? extends TypeMirror> parameterTypes2 = methodType.getParameterTypes().iterator();
        int i = 0;
        while (parameters2.hasNext()) {
            if (i > 0) {
                builder.append(", ");
            }
            this.appendParameter(builder, parameters2.next(), parameterTypes2.next());
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }

    private void appendParameter(StringBuilder builder, VariableElement parameter, TypeMirror type2) {
        this.injectionAnnotations.getQualifier(parameter).ifPresent(qualifier -> builder.append(MethodSignatureFormatter.formatAnnotation(qualifier)).append(' '));
        builder.append(MethodSignatureFormatter.nameOfType(type2));
    }

    private static String nameOfType(TypeMirror type2) {
        return DiagnosticFormatting.stripCommonTypePrefixes(type2.toString());
    }

    private static String formatAnnotation(AnnotationMirror annotation) {
        return DiagnosticFormatting.stripCommonTypePrefixes(annotation.toString());
    }
}

