/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.base.MoreAnnotationValues;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.SuperficialValidation;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public final class InjectionAnnotations {
    private static final Equivalence<AnnotationMirror> EQUIVALENCE = AnnotationMirrors.equivalence();
    private final DaggerElements elements;
    private final KotlinMetadataUtil kotlinMetadataUtil;

    @Inject
    InjectionAnnotations(DaggerElements elements, KotlinMetadataUtil kotlinMetadataUtil) {
        this.elements = elements;
        this.kotlinMetadataUtil = kotlinMetadataUtil;
    }

    public Optional<AnnotationMirror> getQualifier(Element e) {
        if (!SuperficialValidation.validateElement(e)) {
            throw new TypeNotPresentException(e.toString(), null);
        }
        Preconditions.checkNotNull((Object)e);
        ImmutableCollection<? extends AnnotationMirror> qualifierAnnotations = this.getQualifiers(e);
        switch (qualifierAnnotations.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of((AnnotationMirror)qualifierAnnotations.iterator().next());
            }
        }
        throw new IllegalArgumentException(e + " was annotated with more than one @Qualifier annotation");
    }

    public ImmutableCollection<? extends AnnotationMirror> getQualifiers(Element element) {
        ImmutableSet<? extends AnnotationMirror> qualifiers = AnnotationMirrors.getAnnotatedAnnotations(element, Qualifier.class);
        if (element.getKind() == ElementKind.FIELD && !element.getModifiers().contains((Object)Modifier.STATIC) && MoreElements.isAnnotationPresent(element, Inject.class) && this.kotlinMetadataUtil.hasMetadata(element)) {
            return (ImmutableCollection)Stream.concat(qualifiers.stream(), this.getQualifiersForKotlinProperty(MoreElements.asVariable(element)).stream()).map(arg_0 -> EQUIVALENCE.wrap(arg_0)).distinct().map(Equivalence.Wrapper::get).collect(DaggerStreams.toImmutableList());
        }
        return qualifiers.asList();
    }

    public static ImmutableSet<ExecutableElement> injectedConstructors(TypeElement type2) {
        return FluentIterable.from(ElementFilter.constructorsIn(type2.getEnclosedElements())).filter(constructor -> MoreElements.isAnnotationPresent(constructor, Inject.class)).toSet();
    }

    private ImmutableCollection<? extends AnnotationMirror> getQualifiersForKotlinProperty(VariableElement fieldElement) {
        if (this.kotlinMetadataUtil.isMissingSyntheticPropertyForAnnotations(fieldElement)) {
            TypeElement membersInjector = this.elements.getTypeElement(SourceFiles.membersInjectorNameForType(MoreElements.asType(fieldElement.getEnclosingElement())));
            if (membersInjector != null) {
                String memberInjectedFieldSignature = SourceFiles.memberInjectedFieldSignatureForVariable(fieldElement);
                return ((Optional)ElementFilter.methodsIn(membersInjector.getEnclosedElements()).stream().filter(method -> DaggerElements.getAnnotationMirror(method, TypeNames.INJECTED_FIELD_SIGNATURE).map(annotation -> MoreAnnotationValues.getStringValue(annotation, "value")).map(memberInjectedFieldSignature::equals).orElse(false)).collect(DaggerCollectors.toOptional())).map(this::getQualifiers).orElseThrow(() -> new IllegalStateException(String.format("No matching InjectedFieldSignature for %1$s. This likely means that %1$s was compiled with an older, incompatible version of Dagger. Please update all Dagger dependencies to the same version.", memberInjectedFieldSignature)));
            }
            throw new IllegalStateException("No MembersInjector found for " + fieldElement.getEnclosingElement());
        }
        return this.kotlinMetadataUtil.getSyntheticPropertyAnnotations(fieldElement, Qualifier.class);
    }
}

