/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;

public abstract class Formatter<T>
implements Function<T, String> {
    public static final String INDENT = "    ";
    public static final String DOUBLE_INDENT = "        ";
    private static final int LIST_LIMIT = 10;

    public abstract String format(T var1);

    @Deprecated
    public final String apply(T object) {
        return this.format(object);
    }

    public void formatIndentedList(StringBuilder builder, Iterable<? extends T> items, int indentLevel) {
        for (Object item : Iterables.limit(items, (int)10)) {
            String formatted = this.format(item);
            if (formatted.isEmpty()) continue;
            builder.append('\n');
            this.appendIndent(builder, indentLevel);
            builder.append(formatted);
        }
        int numberOfOtherItems = Iterables.size(items) - 10;
        if (numberOfOtherItems > 0) {
            builder.append('\n');
            this.appendIndent(builder, indentLevel);
            builder.append("and ").append(numberOfOtherItems).append(" other");
        }
        if (numberOfOtherItems > 1) {
            builder.append('s');
        }
    }

    private void appendIndent(StringBuilder builder, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            builder.append(INDENT);
        }
    }

    public static String formatArgumentInList(int index, int size, CharSequence name2) {
        Preconditions.checkElementIndex((int)index, (int)size);
        StringBuilder builder = new StringBuilder();
        if (index > 0) {
            builder.append("\u2026, ");
        }
        builder.append(name2);
        if (index < size - 1) {
            builder.append(", \u2026");
        }
        return builder.toString();
    }
}

