/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.validation.XTypeCheckingProcessingStep;
import dagger.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class AssistedFactoryProcessingStep
extends XTypeCheckingProcessingStep<XTypeElement> {
    private final Messager messager;
    private final Filer filer;
    private final SourceVersion sourceVersion;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final BindingFactory bindingFactory;

    @Inject
    AssistedFactoryProcessingStep(Messager messager2, Filer filer, SourceVersion sourceVersion, DaggerElements elements, DaggerTypes types, BindingFactory bindingFactory) {
        this.messager = messager2;
        this.filer = filer;
        this.sourceVersion = sourceVersion;
        this.elements = elements;
        this.types = types;
        this.bindingFactory = bindingFactory;
    }

    public ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)TypeNames.ASSISTED_FACTORY);
    }

    @Override
    protected void process(XTypeElement xElement, ImmutableSet<ClassName> annotations2) {
        TypeElement factory = XConverters.toJavac(xElement);
        ValidationReport<TypeElement> report = new AssistedFactoryValidator().validate(factory);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            try {
                ProvisionBinding binding = this.bindingFactory.assistedFactoryBinding(factory, Optional.empty());
                new AssistedFactoryImplGenerator().generate(binding);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(this.messager);
            }
        }
    }

    private final class AssistedFactoryImplGenerator
    extends SourceFileGenerator<ProvisionBinding> {
        AssistedFactoryImplGenerator() {
            super(AssistedFactoryProcessingStep.this.filer, AssistedFactoryProcessingStep.this.elements, AssistedFactoryProcessingStep.this.sourceVersion);
        }

        @Override
        public Element originatingElement(ProvisionBinding binding) {
            return binding.bindingElement().get();
        }

        @Override
        public ImmutableList<TypeSpec.Builder> topLevelTypes(ProvisionBinding binding) {
            TypeElement factory = MoreElements.asType(binding.bindingElement().get());
            ClassName name2 = SourceFiles.generatedClassNameForBinding(binding);
            TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)name2).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addTypeVariables((Iterable)factory.getTypeParameters().stream().map(TypeVariableName::get).collect(DaggerStreams.toImmutableList()));
            if (factory.getKind() == ElementKind.INTERFACE) {
                builder.addSuperinterface(factory.asType());
            } else {
                builder.superclass(factory.asType());
            }
            AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(MoreTypes.asDeclared(factory.asType()), AssistedFactoryProcessingStep.this.elements, AssistedFactoryProcessingStep.this.types);
            ParameterSpec delegateFactoryParam = ParameterSpec.builder((TypeName)this.delegateFactoryTypeName(metadata.assistedInjectType()), (String)"delegateFactory", (Modifier[])new Modifier[0]).build();
            Object[] objectArray = new Object[2];
            objectArray[0] = delegateFactoryParam;
            objectArray[1] = metadata.assistedInjectAssistedParameters().stream().map(arg_0 -> metadata.assistedFactoryAssistedParametersMap().get(arg_0)).map(param -> CodeBlock.of((String)"$L", (Object[])new Object[]{param.getSimpleName()})).collect(CodeBlocks.toParametersCodeBlock());
            builder.addField(FieldSpec.builder((TypeName)delegateFactoryParam.type, (String)delegateFactoryParam.name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build()).addMethod(MethodSpec.constructorBuilder().addParameter(delegateFactoryParam).addStatement("this.$1N = $1N", new Object[]{delegateFactoryParam}).build()).addMethod(MethodSpec.overriding((ExecutableElement)metadata.factoryMethod(), (DeclaredType)metadata.factoryType(), (Types)AssistedFactoryProcessingStep.this.types).addStatement("return $N.get($L)", objectArray).build()).addMethod(MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(delegateFactoryParam).addTypeVariables((Iterable)metadata.assistedInjectElement().getTypeParameters().stream().map(TypeVariableName::get).collect(DaggerStreams.toImmutableList())).returns((TypeName)TypeNames.providerOf(TypeName.get((TypeMirror)factory.asType()))).addStatement("return $T.$Lcreate(new $T($N))", new Object[]{TypeNames.INSTANCE_FACTORY, AssistedFactoryProcessingStep.this.sourceVersion.compareTo(SourceVersion.RELEASE_7) <= 0 ? CodeBlock.of((String)"<$T>", (Object[])new Object[]{AssistedFactoryProcessingStep.this.types.accessibleType(metadata.factoryType(), name2)}) : CodeBlock.of((String)"", (Object[])new Object[0]), name2, delegateFactoryParam}).build());
            return ImmutableList.of((Object)builder);
        }

        private TypeName delegateFactoryTypeName(DeclaredType assistedInjectType) {
            ClassName generatedFactoryClassName = SourceFiles.generatedClassNameForBinding(AssistedFactoryProcessingStep.this.bindingFactory.injectionBinding((ExecutableElement)Iterables.getOnlyElement(AssistedInjectionAnnotations.assistedInjectedConstructors(MoreTypes.asTypeElement(assistedInjectType))), Optional.empty()));
            return assistedInjectType.getTypeArguments().isEmpty() ? generatedFactoryClassName : ParameterizedTypeName.get((ClassName)generatedFactoryClassName, (TypeName[])((TypeName[])((ImmutableList)assistedInjectType.getTypeArguments().stream().map(TypeName::get).collect(DaggerStreams.toImmutableList())).toArray((Object[])new TypeName[0])));
        }
    }

    private final class AssistedFactoryValidator {
        private AssistedFactoryValidator() {
        }

        ValidationReport<TypeElement> validate(TypeElement factory) {
            ImmutableSet<ExecutableElement> abstractFactoryMethods;
            ValidationReport.Builder<TypeElement> report = ValidationReport.about(factory);
            if (!factory.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return report.addError("The @AssistedFactory-annotated type must be either an abstract class or interface.", factory).build();
            }
            if (factory.getNestingKind().isNested() && !factory.getModifiers().contains((Object)Modifier.STATIC)) {
                report.addError("Nested @AssistedFactory-annotated types must be static. ", factory);
            }
            if ((abstractFactoryMethods = AssistedInjectionAnnotations.assistedFactoryMethods(factory, AssistedFactoryProcessingStep.this.elements)).isEmpty()) {
                report.addError("The @AssistedFactory-annotated type is missing an abstract, non-default method whose return type matches the assisted injection type.", factory);
            }
            for (ExecutableElement method : abstractFactoryMethods) {
                ExecutableType methodType = AssistedFactoryProcessingStep.this.types.resolveExecutableType(method, factory.asType());
                if (!this.isAssistedInjectionType(methodType.getReturnType())) {
                    report.addError(String.format("Invalid return type: %s. An assisted factory's abstract method must return a type with an @AssistedInject-annotated constructor.", methodType.getReturnType()), method);
                }
                if (method.getTypeParameters().isEmpty()) continue;
                report.addError("@AssistedFactory does not currently support type parameters in the creator method. See https://github.com/google/dagger/issues/2279", method);
            }
            if (abstractFactoryMethods.size() > 1) {
                report.addError("The @AssistedFactory-annotated type should contain a single abstract, non-default method but found multiple: " + abstractFactoryMethods, factory);
            }
            if (!report.build().isClean()) {
                return report.build();
            }
            AssistedInjectionAnnotations.AssistedFactoryMetadata metadata = AssistedInjectionAnnotations.AssistedFactoryMetadata.create(factory.asType(), AssistedFactoryProcessingStep.this.elements, AssistedFactoryProcessingStep.this.types);
            HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
            for (AssistedInjectionAnnotations.AssistedParameter assistedParameter : metadata.assistedFactoryAssistedParameters()) {
                if (uniqueAssistedParameters.add(assistedParameter)) continue;
                report.addError("@AssistedFactory method has duplicate @Assisted types: " + assistedParameter, assistedParameter.variableElement());
            }
            if (!ImmutableSet.copyOf(metadata.assistedInjectAssistedParameters()).equals((Object)ImmutableSet.copyOf(metadata.assistedFactoryAssistedParameters()))) {
                report.addError(String.format("The parameters in the factory method must match the @Assisted parameters in %s.\n      Actual: %s#%s\n    Expected: %s#%s(%s)", metadata.assistedInjectType(), metadata.factory().getQualifiedName(), metadata.factoryMethod(), metadata.factory().getQualifiedName(), metadata.factoryMethod().getSimpleName(), metadata.assistedInjectAssistedParameters().stream().map(AssistedInjectionAnnotations.AssistedParameter::type).map(Object::toString).collect(Collectors.joining(", "))), metadata.factoryMethod());
            }
            return report.build();
        }

        private boolean isAssistedInjectionType(TypeMirror type2) {
            return type2.getKind() == TypeKind.DECLARED && AssistedInjectionAnnotations.isAssistedInjectionType(MoreTypes.asTypeElement(type2));
        }
    }
}

