/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.FrameworkInstanceBindingExpression;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.ProducerEntryPointView;
import dagger.model.Key;
import dagger.producers.internal.Producers;

final class ProducerNodeInstanceBindingExpression
extends FrameworkInstanceBindingExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final Key key;
    private final ProducerEntryPointView producerEntryPointView;

    @AssistedInject
    ProducerNodeInstanceBindingExpression(@Assisted ContributionBinding binding, @Assisted FrameworkInstanceSupplier frameworkInstanceSupplier, DaggerTypes types, DaggerElements elements, ComponentImplementation componentImplementation) {
        super(binding, frameworkInstanceSupplier, types, elements);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.key = binding.key();
        this.producerEntryPointView = new ProducerEntryPointView(this.shardImplementation, types);
    }

    @Override
    protected FrameworkType frameworkType() {
        return FrameworkType.PRODUCER_NODE;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression result = super.getDependencyExpression(requestingClass);
        this.shardImplementation.addCancellation(this.key, CodeBlock.of((String)"$T.cancel($L, $N);", (Object[])new Object[]{Producers.class, result.codeBlock(), ComponentImplementation.MAY_INTERRUPT_IF_RUNNING_PARAM}));
        return result;
    }

    @Override
    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        return this.producerEntryPointView.getProducerEntryPointField(this, componentMethod, component.name()).orElseGet(() -> super.getDependencyExpressionForComponentMethod(componentMethod, component));
    }

    @AssistedFactory
    static interface Factory {
        public ProducerNodeInstanceBindingExpression create(ContributionBinding var1, FrameworkInstanceSupplier var2);
    }
}

