/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

abstract class BindingMethodValidator
extends BindingElementValidator<ExecutableElement> {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final KotlinMetadataUtil metadataUtil;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final ClassName methodAnnotation;
    private final ImmutableSet<ClassName> enclosingElementAnnotations;
    private final Abstractness abstractness;
    private final ExceptionSuperclass exceptionSuperclass;

    protected BindingMethodValidator(DaggerElements elements, DaggerTypes types, KotlinMetadataUtil metadataUtil, DependencyRequestValidator dependencyRequestValidator, ClassName methodAnnotation, ClassName enclosingElementAnnotation, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, BindingElementValidator.AllowsMultibindings allowsMultibindings, BindingElementValidator.AllowsScoping allowsScoping, InjectionAnnotations injectionAnnotations) {
        this(elements, types, metadataUtil, methodAnnotation, (Iterable<ClassName>)ImmutableSet.of((Object)enclosingElementAnnotation), dependencyRequestValidator, abstractness, exceptionSuperclass, allowsMultibindings, allowsScoping, injectionAnnotations);
    }

    protected BindingMethodValidator(DaggerElements elements, DaggerTypes types, KotlinMetadataUtil metadataUtil, ClassName methodAnnotation, Iterable<ClassName> enclosingElementAnnotations, DependencyRequestValidator dependencyRequestValidator, Abstractness abstractness, ExceptionSuperclass exceptionSuperclass, BindingElementValidator.AllowsMultibindings allowsMultibindings, BindingElementValidator.AllowsScoping allowsScoping, InjectionAnnotations injectionAnnotations) {
        super(methodAnnotation, allowsMultibindings, allowsScoping, injectionAnnotations);
        this.elements = elements;
        this.types = types;
        this.metadataUtil = metadataUtil;
        this.methodAnnotation = methodAnnotation;
        this.enclosingElementAnnotations = ImmutableSet.copyOf(enclosingElementAnnotations);
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.abstractness = abstractness;
        this.exceptionSuperclass = exceptionSuperclass;
    }

    final ClassName methodAnnotation() {
        return this.methodAnnotation;
    }

    @FormatMethod
    protected final String bindingMethods(String ruleFormat, Object ... args) {
        return this.bindingElements(ruleFormat, args);
    }

    @Override
    protected final String bindingElements() {
        return String.format("@%s methods", this.methodAnnotation.simpleName());
    }

    @Override
    protected final String bindingElementTypeVerb() {
        return "return";
    }

    protected static enum ExceptionSuperclass {
        NO_EXCEPTIONS{

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may not throw", new Object[0]);
            }

            @Override
            protected void checkThrows(BindingMethodValidator validator, ExecutableElement element, ValidationReport.Builder<ExecutableElement> report) {
                if (!element.getThrownTypes().isEmpty()) {
                    report.addError(validator.bindingMethods("may not throw", new Object[0]));
                    return;
                }
            }
        }
        ,
        EXCEPTION(Exception.class){

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may only throw unchecked exceptions or exceptions subclassing Exception", new Object[0]);
            }
        }
        ,
        RUNTIME_EXCEPTION(RuntimeException.class){

            @Override
            protected String errorMessage(BindingMethodValidator validator) {
                return validator.bindingMethods("may only throw unchecked exceptions", new Object[0]);
            }
        };

        private final Class<? extends Exception> superclass;

        private ExceptionSuperclass() {
            this((Class<? extends Exception>)null);
        }

        private ExceptionSuperclass(Class<? extends Exception> superclass) {
            this.superclass = superclass;
        }

        protected void checkThrows(BindingMethodValidator validator, ExecutableElement element, ValidationReport.Builder<ExecutableElement> report) {
            TypeMirror exceptionSupertype = validator.elements.getTypeElement(this.superclass).asType();
            TypeMirror errorType = validator.elements.getTypeElement(Error.class).asType();
            for (TypeMirror typeMirror : element.getThrownTypes()) {
                if (validator.types.isSubtype(typeMirror, exceptionSupertype) || validator.types.isSubtype(typeMirror, errorType)) continue;
                report.addError(this.errorMessage(validator));
                break;
            }
        }

        protected abstract String errorMessage(BindingMethodValidator var1);
    }

    protected static enum Abstractness {
        MUST_BE_ABSTRACT,
        MUST_BE_CONCRETE;

    }

    protected abstract class MethodValidator
    extends BindingElementValidator.ElementValidator {
        protected MethodValidator(ExecutableElement element) {
            super((BindingElementValidator)BindingMethodValidator.this, (Element)element);
        }

        @Override
        protected final Optional<TypeMirror> bindingElementType() {
            return Optional.of(((ExecutableElement)this.element).getReturnType());
        }

        @Override
        protected final void checkAdditionalProperties() {
            this.checkEnclosingElement();
            this.checkTypeParameters();
            this.checkNotPrivate();
            this.checkAbstractness();
            this.checkThrows();
            this.checkParameters();
            this.checkAdditionalMethodProperties();
        }

        protected void checkAdditionalMethodProperties() {
        }

        private void checkEnclosingElement() {
            TypeElement enclosingElement = MoreElements.asType(((ExecutableElement)this.element).getEnclosingElement());
            if (BindingMethodValidator.this.metadataUtil.isCompanionObjectClass(enclosingElement)) {
                enclosingElement = MoreElements.asType(enclosingElement.getEnclosingElement());
            }
            if (!DaggerElements.isAnyAnnotationPresent(enclosingElement, (Iterable<ClassName>)BindingMethodValidator.this.enclosingElementAnnotations)) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("can only be present within a @%s", BindingMethodValidator.this.enclosingElementAnnotations.stream().map(ClassName::simpleName).collect(Collectors.joining(" or @"))));
            }
        }

        private void checkTypeParameters() {
            if (!((ExecutableElement)this.element).getTypeParameters().isEmpty()) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("may not have type parameters", new Object[0]));
            }
        }

        private void checkNotPrivate() {
            if (((ExecutableElement)this.element).getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.report.addError(BindingMethodValidator.this.bindingMethods("cannot be private", new Object[0]));
            }
        }

        private void checkAbstractness() {
            boolean isAbstract = ((ExecutableElement)this.element).getModifiers().contains((Object)Modifier.ABSTRACT);
            switch (BindingMethodValidator.this.abstractness) {
                case MUST_BE_ABSTRACT: {
                    if (isAbstract) break;
                    this.report.addError(BindingMethodValidator.this.bindingMethods("must be abstract", new Object[0]));
                    break;
                }
                case MUST_BE_CONCRETE: {
                    if (!isAbstract) break;
                    this.report.addError(BindingMethodValidator.this.bindingMethods("cannot be abstract", new Object[0]));
                }
            }
        }

        private void checkThrows() {
            BindingMethodValidator.this.exceptionSuperclass.checkThrows(BindingMethodValidator.this, (ExecutableElement)this.element, this.report);
        }

        protected void checkParameters() {
            for (VariableElement variableElement : ((ExecutableElement)this.element).getParameters()) {
                this.checkParameter(variableElement);
            }
        }

        protected void checkParameter(VariableElement parameter) {
            BindingMethodValidator.this.dependencyRequestValidator.validateDependencyRequest(this.report, parameter, parameter.asType());
        }
    }
}

