/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.binding.AutoValue_FrameworkField;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.model.BindingKind;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor8;

@AutoValue
public abstract class FrameworkField {
    private static final ElementVisitor<String, Binding> BINDING_ELEMENT_NAME = new ElementKindVisitor8<String, Binding>(){

        @Override
        protected String defaultAction(Element e, Binding p) {
            throw new IllegalArgumentException("Unexpected binding " + p);
        }

        @Override
        public String visitExecutableAsConstructor(ExecutableElement e, Binding p) {
            return (String)this.visit(e.getEnclosingElement(), p);
        }

        @Override
        public String visitExecutableAsMethod(ExecutableElement e, Binding p) {
            return e.getSimpleName().toString();
        }

        @Override
        public String visitType(TypeElement e, Binding p) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, e.getSimpleName().toString());
        }

        @Override
        public String visitVariableAsParameter(VariableElement e, Binding p) {
            return e.getSimpleName().toString();
        }
    };

    public static FrameworkField create(ClassName frameworkClassName, TypeName valueTypeName, String fieldName) {
        String suffix = frameworkClassName.simpleName();
        return new AutoValue_FrameworkField(ParameterizedTypeName.get((ClassName)frameworkClassName, (TypeName[])new TypeName[]{valueTypeName}), fieldName.endsWith(suffix) ? fieldName : fieldName + suffix);
    }

    public static FrameworkField forBinding(ContributionBinding binding, Optional<ClassName> frameworkClass) {
        return FrameworkField.create(frameworkClass.orElse(ClassName.get(FrameworkType.forBindingType(binding.bindingType()).frameworkClass())), TypeName.get((TypeMirror)FrameworkField.fieldValueType(binding)), FrameworkField.frameworkFieldName(binding));
    }

    private static TypeMirror fieldValueType(ContributionBinding binding) {
        return binding.contributionType().isMultibinding() ? binding.contributedType() : binding.key().type();
    }

    private static String frameworkFieldName(ContributionBinding binding) {
        if (binding.bindingElement().isPresent()) {
            String name = BINDING_ELEMENT_NAME.visit(binding.bindingElement().get(), binding);
            return binding.kind().equals((Object)BindingKind.MEMBERS_INJECTOR) ? name + "MembersInjector" : name;
        }
        return KeyVariableNamer.name(binding.key());
    }

    public abstract ParameterizedTypeName type();

    public abstract String name();
}

