/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import dagger.BindsInstance;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ErrorMessages;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@Singleton
public final class ComponentCreatorValidator
implements ClearableCache {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final Map<TypeElement, ValidationReport<TypeElement>> reports = new HashMap<TypeElement, ValidationReport<TypeElement>>();

    @Inject
    ComponentCreatorValidator(DaggerElements elements, DaggerTypes types) {
        this.elements = elements;
        this.types = types;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    public ValidationReport<TypeElement> validate(TypeElement type) {
        return Util.reentrantComputeIfAbsent(this.reports, type, this::validateUncached);
    }

    private ValidationReport<TypeElement> validateUncached(TypeElement type) {
        ValidationReport.Builder<TypeElement> report = ValidationReport.about(type);
        ImmutableSet<ComponentCreatorAnnotation> creatorAnnotations = ComponentCreatorAnnotation.getCreatorAnnotations(type);
        if (!this.validateOnlyOneCreatorAnnotation(creatorAnnotations, report)) {
            return report.build();
        }
        ElementValidator validator = new ElementValidator(type, report, (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(creatorAnnotations)));
        return validator.validate();
    }

    private boolean validateOnlyOneCreatorAnnotation(ImmutableSet<ComponentCreatorAnnotation> creatorAnnotations, ValidationReport.Builder<?> report) {
        if (creatorAnnotations.size() > 1) {
            String error = "May not have more than one component Factory or Builder annotation on a type: found " + creatorAnnotations;
            report.addError(error);
            return false;
        }
        return true;
    }

    private final class ElementValidator {
        private final TypeElement type;
        private final Element component;
        private final ValidationReport.Builder<TypeElement> report;
        private final ComponentCreatorAnnotation annotation;
        private final ErrorMessages.ComponentCreatorMessages messages;

        private ElementValidator(TypeElement type, ValidationReport.Builder<TypeElement> report, ComponentCreatorAnnotation annotation) {
            this.type = type;
            this.component = type.getEnclosingElement();
            this.report = report;
            this.annotation = annotation;
            this.messages = ErrorMessages.creatorMessagesFor(annotation);
        }

        final ValidationReport<TypeElement> validate() {
            if (!MoreElements.isAnnotationPresent(this.component, this.annotation.componentAnnotation())) {
                this.report.addError(this.messages.mustBeInComponent());
            }
            if (!this.validateIsClassOrInterface()) {
                return this.report.build();
            }
            this.validateTypeRequirements();
            switch (this.annotation.creatorKind()) {
                case FACTORY: {
                    this.validateFactory();
                    break;
                }
                case BUILDER: {
                    this.validateBuilder();
                }
            }
            return this.report.build();
        }

        private boolean validateIsClassOrInterface() {
            switch (this.type.getKind()) {
                case CLASS: {
                    this.validateConstructor();
                    return true;
                }
                case INTERFACE: {
                    return true;
                }
            }
            this.report.addError(this.messages.mustBeClassOrInterface());
            return false;
        }

        private void validateConstructor() {
            List<? extends Element> allElements = this.type.getEnclosedElements();
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(allElements);
            boolean valid = true;
            if (constructors.size() != 1) {
                valid = false;
            } else {
                ExecutableElement constructor = (ExecutableElement)Iterables.getOnlyElement(constructors);
                boolean bl = valid = constructor.getParameters().isEmpty() && !constructor.getModifiers().contains((Object)Modifier.PRIVATE);
            }
            if (!valid) {
                this.report.addError(this.messages.invalidConstructor());
            }
        }

        private void validateTypeRequirements() {
            Set<Modifier> modifiers;
            if (!this.type.getTypeParameters().isEmpty()) {
                this.report.addError(this.messages.generics());
            }
            if ((modifiers = this.type.getModifiers()).contains((Object)Modifier.PRIVATE)) {
                this.report.addError(this.messages.isPrivate());
            }
            if (!modifiers.contains((Object)Modifier.STATIC)) {
                this.report.addError(this.messages.mustBeStatic());
            }
            if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
                this.report.addError(this.messages.mustBeAbstract());
            }
        }

        private void validateBuilder() {
            ExecutableElement buildMethod = null;
            block4: for (ExecutableElement method : ComponentCreatorValidator.this.elements.getUnimplementedMethods(this.type)) {
                switch (method.getParameters().size()) {
                    case 0: {
                        if (this.validateFactoryMethodReturnType(method) && buildMethod != null) {
                            this.error(method, this.messages.twoFactoryMethods(), this.messages.inheritedTwoFactoryMethods(), buildMethod);
                        }
                        buildMethod = method;
                        continue block4;
                    }
                    case 1: {
                        this.validateSetterMethod(method);
                        continue block4;
                    }
                }
                this.error(method, this.messages.setterMethodsMustTakeOneArg(), this.messages.inheritedSetterMethodsMustTakeOneArg(), new Object[0]);
            }
            if (buildMethod == null) {
                this.report.addError(this.messages.missingFactoryMethod());
            } else {
                this.validateNotGeneric(buildMethod);
            }
        }

        private void validateSetterMethod(ExecutableElement method) {
            boolean bindsInstance;
            TypeMirror returnType = ComponentCreatorValidator.this.types.resolveExecutableType(method, this.type.asType()).getReturnType();
            if (returnType.getKind() != TypeKind.VOID && !ComponentCreatorValidator.this.types.isSubtype(this.type.asType(), returnType)) {
                this.error(method, this.messages.setterMethodsMustReturnVoidOrBuilder(), this.messages.inheritedSetterMethodsMustReturnVoidOrBuilder(), new Object[0]);
            }
            this.validateNotGeneric(method);
            VariableElement parameter = method.getParameters().get(0);
            boolean methodIsBindsInstance = MoreElements.isAnnotationPresent(method, BindsInstance.class);
            boolean parameterIsBindsInstance = MoreElements.isAnnotationPresent(parameter, BindsInstance.class);
            boolean bl = bindsInstance = methodIsBindsInstance || parameterIsBindsInstance;
            if (methodIsBindsInstance && parameterIsBindsInstance) {
                this.error(method, this.messages.bindsInstanceNotAllowedOnBothSetterMethodAndParameter(), this.messages.inheritedBindsInstanceNotAllowedOnBothSetterMethodAndParameter(), new Object[0]);
            }
            if (!bindsInstance && parameter.asType().getKind().isPrimitive()) {
                this.error(method, this.messages.nonBindsInstanceParametersMayNotBePrimitives(), this.messages.inheritedNonBindsInstanceParametersMayNotBePrimitives(), new Object[0]);
            }
        }

        private void validateFactory() {
            ImmutableList abstractMethods = ComponentCreatorValidator.this.elements.getUnimplementedMethods(this.type).asList();
            switch (abstractMethods.size()) {
                case 0: {
                    this.report.addError(this.messages.missingFactoryMethod());
                    return;
                }
                case 1: {
                    break;
                }
                default: {
                    this.error((ExecutableElement)abstractMethods.get(1), this.messages.twoFactoryMethods(), this.messages.inheritedTwoFactoryMethods(), abstractMethods.get(0));
                    return;
                }
            }
            this.validateFactoryMethod((ExecutableElement)Iterables.getOnlyElement((Iterable)abstractMethods));
        }

        private void validateFactoryMethod(ExecutableElement method) {
            this.validateNotGeneric(method);
            if (!this.validateFactoryMethodReturnType(method)) {
                return;
            }
            for (VariableElement variableElement : method.getParameters()) {
                if (MoreElements.isAnnotationPresent(variableElement, BindsInstance.class) || !variableElement.asType().getKind().isPrimitive()) continue;
                this.error(method, this.messages.nonBindsInstanceParametersMayNotBePrimitives(), this.messages.inheritedNonBindsInstanceParametersMayNotBePrimitives(), new Object[0]);
            }
        }

        private boolean validateFactoryMethodReturnType(ExecutableElement method) {
            ImmutableSet<ExecutableElement> methodsOnlyInComponent;
            TypeMirror returnType = ComponentCreatorValidator.this.types.resolveExecutableType(method, this.type.asType()).getReturnType();
            if (!ComponentCreatorValidator.this.types.isSubtype(this.component.asType(), returnType)) {
                this.error(method, this.messages.factoryMethodMustReturnComponentType(), this.messages.inheritedFactoryMethodMustReturnComponentType(), new Object[0]);
                return false;
            }
            if (MoreElements.isAnnotationPresent(method, BindsInstance.class)) {
                this.error(method, this.messages.factoryMethodMayNotBeAnnotatedWithBindsInstance(), this.messages.inheritedFactoryMethodMayNotBeAnnotatedWithBindsInstance(), new Object[0]);
                return false;
            }
            TypeElement componentType = MoreElements.asType(this.component);
            if (!ComponentCreatorValidator.this.types.isSameType(componentType.asType(), returnType) && !(methodsOnlyInComponent = this.methodsOnlyInComponent(componentType)).isEmpty()) {
                this.report.addWarning(this.messages.factoryMethodReturnsSupertypeWithMissingMethods(componentType, this.type, returnType, method, (Set<ExecutableElement>)methodsOnlyInComponent), method);
            }
            return true;
        }

        private void error(ExecutableElement method, String enclosedError, String inheritedError, Object ... extraArgs) {
            if (method.getEnclosingElement().equals(this.type)) {
                this.report.addError(String.format(enclosedError, extraArgs), method);
            } else {
                this.report.addError(String.format(inheritedError, ObjectArrays.concat((Object[])extraArgs, (Object)method)));
            }
        }

        private void validateNotGeneric(ExecutableElement method) {
            if (!method.getTypeParameters().isEmpty()) {
                this.error(method, this.messages.methodsMayNotHaveTypeParameters(), this.messages.inheritedMethodsMayNotHaveTypeParameters(), new Object[0]);
            }
        }

        private ImmutableSet<ExecutableElement> methodsOnlyInComponent(TypeElement componentType) {
            return ImmutableSet.copyOf(ElementFilter.methodsIn(componentType.getEnclosedElements()));
        }
    }
}

