/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;

final class AssistedInjectProcessingStep
extends TypeCheckingProcessingStep<ExecutableElement> {
    private final DaggerTypes types;
    private final Messager messager;

    @Inject
    AssistedInjectProcessingStep(DaggerTypes types, Messager messager) {
        super(MoreElements::asExecutable);
        this.types = types;
        this.messager = messager;
    }

    public ImmutableSet<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(AssistedInject.class);
    }

    @Override
    protected void process(ExecutableElement assistedInjectElement, ImmutableSet<Class<? extends Annotation>> annotations) {
        new AssistedInjectValidator().validate(assistedInjectElement).printMessagesTo(this.messager);
    }

    private final class AssistedInjectValidator {
        private AssistedInjectValidator() {
        }

        ValidationReport<ExecutableElement> validate(ExecutableElement constructor) {
            Preconditions.checkState((constructor.getKind() == ElementKind.CONSTRUCTOR ? 1 : 0) != 0);
            ValidationReport.Builder<ExecutableElement> report = ValidationReport.about(constructor);
            DeclaredType assistedInjectType = MoreTypes.asDeclared(DaggerElements.closestEnclosingTypeElement(constructor).asType());
            ImmutableList<AssistedInjectionAnnotations.AssistedParameter> assistedParameters = AssistedInjectionAnnotations.assistedInjectAssistedParameters(assistedInjectType, AssistedInjectProcessingStep.this.types);
            HashSet<AssistedInjectionAnnotations.AssistedParameter> uniqueAssistedParameters = new HashSet<AssistedInjectionAnnotations.AssistedParameter>();
            for (AssistedInjectionAnnotations.AssistedParameter assistedParameter : assistedParameters) {
                if (uniqueAssistedParameters.add(assistedParameter)) continue;
                report.addError(String.format("@AssistedInject constructor has duplicate @Assisted type: %s. Consider setting an identifier on the parameter by using @Assisted(\"identifier\") in both the factory and @AssistedInject constructor", assistedParameter), assistedParameter.variableElement());
            }
            return report.build();
        }
    }
}

