/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.ExecutableElement;

@Singleton
public final class AnyBindingMethodValidator
implements ClearableCache {
    private final ImmutableMap<Class<? extends Annotation>, BindingMethodValidator> validators;
    private final Map<ExecutableElement, ValidationReport<ExecutableElement>> reports = new HashMap<ExecutableElement, ValidationReport<ExecutableElement>>();

    @Inject
    AnyBindingMethodValidator(ImmutableMap<Class<? extends Annotation>, BindingMethodValidator> validators) {
        this.validators = validators;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    ImmutableSet<Class<? extends Annotation>> methodAnnotations() {
        return this.validators.keySet();
    }

    boolean isBindingMethod(ExecutableElement method) {
        return DaggerElements.isAnyAnnotationPresent(method, this.methodAnnotations());
    }

    ValidationReport<ExecutableElement> validate(ExecutableElement method) {
        return Util.reentrantComputeIfAbsent(this.reports, method, this::validateUncached);
    }

    boolean wasAlreadyValidated(ExecutableElement method) {
        return this.reports.containsKey(method);
    }

    private ValidationReport<ExecutableElement> validateUncached(ExecutableElement method) {
        ValidationReport.Builder<ExecutableElement> report = ValidationReport.about(method);
        ImmutableSet bindingMethodAnnotations = (ImmutableSet)this.methodAnnotations().stream().filter(annotation -> MoreElements.isAnnotationPresent(method, annotation)).collect(DaggerStreams.toImmutableSet());
        switch (bindingMethodAnnotations.size()) {
            case 0: {
                throw new IllegalArgumentException(String.format("%s has no binding method annotation", method));
            }
            case 1: {
                report.addSubreport(((BindingMethodValidator)this.validators.get(Iterables.getOnlyElement((Iterable)bindingMethodAnnotations))).validate(method));
                break;
            }
            default: {
                report.addError(String.format("%s is annotated with more than one of (%s)", method.getSimpleName(), this.methodAnnotations().stream().map(Class::getCanonicalName).collect(Collectors.joining(", "))), method);
            }
        }
        return report.build();
    }
}

