/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.Traverser;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.Provides;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.AutoValue_ModuleDescriptor;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingFactory;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DelegateDeclaration;
import dagger.internal.codegen.binding.ModuleKind;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.model.Key;
import dagger.multibindings.Multibinds;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@AutoValue
public abstract class ModuleDescriptor {
    public abstract TypeElement moduleElement();

    abstract ImmutableSet<TypeElement> includedModules();

    public abstract ImmutableSet<ContributionBinding> bindings();

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    abstract ImmutableSet<DelegateDeclaration> delegateDeclarations();

    abstract ImmutableSet<OptionalBindingDeclaration> optionalDeclarations();

    public abstract ModuleKind kind();

    public ImmutableSet<BindingDeclaration> allBindingDeclarations() {
        return ImmutableSet.builder().addAll(this.bindings()).addAll(this.delegateDeclarations()).addAll(this.multibindingDeclarations()).addAll(this.optionalDeclarations()).addAll(this.subcomponentDeclarations()).build();
    }

    ImmutableSet<Key> allBindingKeys() {
        return (ImmutableSet)this.allBindingDeclarations().stream().map(BindingDeclaration::key).collect(DaggerStreams.toImmutableSet());
    }

    @Singleton
    public static final class Factory
    implements ClearableCache {
        private final DaggerElements elements;
        private final KotlinMetadataUtil metadataUtil;
        private final BindingFactory bindingFactory;
        private final MultibindingDeclaration.Factory multibindingDeclarationFactory;
        private final DelegateDeclaration.Factory bindingDelegateDeclarationFactory;
        private final SubcomponentDeclaration.Factory subcomponentDeclarationFactory;
        private final OptionalBindingDeclaration.Factory optionalBindingDeclarationFactory;
        private final Map<TypeElement, ModuleDescriptor> cache = new HashMap<TypeElement, ModuleDescriptor>();

        @Inject
        Factory(DaggerElements elements, KotlinMetadataUtil metadataUtil, BindingFactory bindingFactory, MultibindingDeclaration.Factory multibindingDeclarationFactory, DelegateDeclaration.Factory bindingDelegateDeclarationFactory, SubcomponentDeclaration.Factory subcomponentDeclarationFactory, OptionalBindingDeclaration.Factory optionalBindingDeclarationFactory) {
            this.elements = elements;
            this.metadataUtil = metadataUtil;
            this.bindingFactory = bindingFactory;
            this.multibindingDeclarationFactory = multibindingDeclarationFactory;
            this.bindingDelegateDeclarationFactory = bindingDelegateDeclarationFactory;
            this.subcomponentDeclarationFactory = subcomponentDeclarationFactory;
            this.optionalBindingDeclarationFactory = optionalBindingDeclarationFactory;
        }

        public ModuleDescriptor create(TypeElement moduleElement) {
            return Util.reentrantComputeIfAbsent(this.cache, moduleElement, this::createUncached);
        }

        public ModuleDescriptor createUncached(TypeElement moduleElement) {
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            ImmutableSet.Builder delegates = ImmutableSet.builder();
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            ImmutableSet.Builder optionalDeclarations = ImmutableSet.builder();
            for (ExecutableElement moduleMethod : ElementFilter.methodsIn(this.elements.getAllMembers(moduleElement))) {
                if (MoreElements.isAnnotationPresent(moduleMethod, Provides.class)) {
                    bindings.add((Object)this.bindingFactory.providesMethodBinding(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Produces.class)) {
                    bindings.add((Object)this.bindingFactory.producesMethodBinding(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Binds.class)) {
                    delegates.add((Object)this.bindingDelegateDeclarationFactory.create(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Multibinds.class)) {
                    multibindingDeclarations.add((Object)this.multibindingDeclarationFactory.forMultibindsMethod(moduleMethod, moduleElement));
                }
                if (!MoreElements.isAnnotationPresent(moduleMethod, BindsOptionalOf.class)) continue;
                optionalDeclarations.add((Object)this.optionalBindingDeclarationFactory.forMethod(moduleMethod, moduleElement));
            }
            if (this.metadataUtil.hasEnclosedCompanionObject(moduleElement)) {
                this.collectCompanionModuleBindings(moduleElement, (ImmutableSet.Builder<ContributionBinding>)bindings);
            }
            return new AutoValue_ModuleDescriptor(moduleElement, (ImmutableSet<TypeElement>)ImmutableSet.copyOf(this.collectIncludedModules(new LinkedHashSet<TypeElement>(), moduleElement)), (ImmutableSet<ContributionBinding>)bindings.build(), (ImmutableSet<MultibindingDeclaration>)multibindingDeclarations.build(), this.subcomponentDeclarationFactory.forModule(moduleElement), (ImmutableSet<DelegateDeclaration>)delegates.build(), (ImmutableSet<OptionalBindingDeclaration>)optionalDeclarations.build(), ModuleKind.forAnnotatedElement(moduleElement).get());
        }

        private void collectCompanionModuleBindings(TypeElement moduleElement, ImmutableSet.Builder<ContributionBinding> bindings) {
            Preconditions.checkArgument((boolean)this.metadataUtil.hasEnclosedCompanionObject(moduleElement));
            TypeElement companionModule = this.metadataUtil.getEnclosedCompanionObject(moduleElement);
            ImmutableSet bindingElementDescriptors = (ImmutableSet)bindings.build().stream().map(binding -> DaggerElements.getMethodDescriptor(MoreElements.asExecutable(binding.bindingElement().get()))).collect(DaggerStreams.toImmutableSet());
            ElementFilter.methodsIn(this.elements.getAllMembers(companionModule)).stream().filter(method -> !KotlinMetadataUtil.isJvmStaticPresent(method)).filter(method -> !bindingElementDescriptors.contains((Object)DaggerElements.getMethodDescriptor(method))).forEach(method -> {
                if (MoreElements.isAnnotationPresent(method, Provides.class)) {
                    bindings.add((Object)this.bindingFactory.providesMethodBinding((ExecutableElement)method, companionModule));
                }
                if (MoreElements.isAnnotationPresent(method, Produces.class)) {
                    bindings.add((Object)this.bindingFactory.producesMethodBinding((ExecutableElement)method, companionModule));
                }
            });
        }

        ImmutableSet<ModuleDescriptor> transitiveModules(Iterable<TypeElement> modules) {
            return ImmutableSet.copyOf((Iterable)Traverser.forGraph(module -> Iterables.transform(module.includedModules(), this::create)).depthFirstPreOrder(Iterables.transform(modules, this::create)));
        }

        @CanIgnoreReturnValue
        private Set<TypeElement> collectIncludedModules(Set<TypeElement> includedModules, TypeElement moduleElement) {
            TypeMirror superclass = moduleElement.getSuperclass();
            if (!superclass.getKind().equals((Object)TypeKind.NONE)) {
                Verify.verify((boolean)superclass.getKind().equals((Object)TypeKind.DECLARED));
                TypeElement superclassElement = MoreTypes.asTypeElement(superclass);
                if (!superclassElement.getQualifiedName().contentEquals(Object.class.getCanonicalName())) {
                    this.collectIncludedModules(includedModules, superclassElement);
                }
            }
            ModuleAnnotation.moduleAnnotation(moduleElement).ifPresent(moduleAnnotation -> {
                includedModules.addAll((Collection<TypeElement>)moduleAnnotation.includes());
                includedModules.addAll((Collection<TypeElement>)this.implicitlyIncludedModules(moduleElement));
            });
            return includedModules;
        }

        private ImmutableSet<TypeElement> implicitlyIncludedModules(TypeElement moduleElement) {
            TypeElement contributesAndroidInjector = this.elements.getTypeElement("dagger.android.ContributesAndroidInjector");
            if (contributesAndroidInjector == null) {
                return ImmutableSet.of();
            }
            return (ImmutableSet)ElementFilter.methodsIn(moduleElement.getEnclosedElements()).stream().filter(method -> DaggerElements.isAnnotationPresent(method, contributesAndroidInjector.asType())).map(method -> this.elements.checkTypePresent(this.implicitlyIncludedModuleName((ExecutableElement)method))).collect(DaggerStreams.toImmutableSet());
        }

        private String implicitlyIncludedModuleName(ExecutableElement method) {
            return MoreElements.getPackage(method).getQualifiedName() + "." + SourceFiles.classFileName(ClassName.get((TypeElement)MoreElements.asType(method.getEnclosingElement()))) + "_" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, method.getSimpleName().toString());
        }

        @Override
        public void clearCache() {
            this.cache.clear();
        }
    }
}

