/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import dagger.Component;
import dagger.Subcomponent;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.TypeElement;

public enum ComponentCreatorAnnotation {
    COMPONENT_BUILDER(Component.Builder.class),
    COMPONENT_FACTORY(Component.Factory.class),
    SUBCOMPONENT_BUILDER(Subcomponent.Builder.class),
    SUBCOMPONENT_FACTORY(Subcomponent.Factory.class),
    PRODUCTION_COMPONENT_BUILDER(ProductionComponent.Builder.class),
    PRODUCTION_COMPONENT_FACTORY(ProductionComponent.Factory.class),
    PRODUCTION_SUBCOMPONENT_BUILDER(ProductionSubcomponent.Builder.class),
    PRODUCTION_SUBCOMPONENT_FACTORY(ProductionSubcomponent.Factory.class);

    private final Class<? extends Annotation> annotation;
    private final ComponentCreatorKind creatorKind;
    private final Class<? extends Annotation> componentAnnotation;

    private ComponentCreatorAnnotation(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
        this.creatorKind = ComponentCreatorKind.valueOf(Ascii.toUpperCase((String)annotation.getSimpleName()));
        this.componentAnnotation = annotation.getEnclosingClass();
    }

    public Class<? extends Annotation> annotation() {
        return this.annotation;
    }

    public final Class<? extends Annotation> componentAnnotation() {
        return this.componentAnnotation;
    }

    public final boolean isSubcomponentCreatorAnnotation() {
        return this.componentAnnotation().getSimpleName().endsWith("Subcomponent");
    }

    public final boolean isProductionCreatorAnnotation() {
        return this.componentAnnotation().getSimpleName().startsWith("Production");
    }

    public ComponentCreatorKind creatorKind() {
        return this.creatorKind;
    }

    public final String toString() {
        return this.annotation().getName();
    }

    public static ImmutableSet<Class<? extends Annotation>> allCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<Class<? extends Annotation>> rootComponentCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> !componentCreatorAnnotation.isSubcomponentCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<Class<? extends Annotation>> subcomponentCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> componentCreatorAnnotation.isSubcomponentCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<Class<? extends Annotation>> productionCreatorAnnotations() {
        return ComponentCreatorAnnotation.stream().filter(componentCreatorAnnotation -> componentCreatorAnnotation.isProductionCreatorAnnotation()).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<Class<? extends Annotation>> creatorAnnotationsFor(ComponentAnnotation componentAnnotation) {
        return ComponentCreatorAnnotation.stream().filter(creatorAnnotation -> creatorAnnotation.componentAnnotation().getSimpleName().equals(componentAnnotation.simpleName())).collect(ComponentCreatorAnnotation.toAnnotationClasses());
    }

    public static ImmutableSet<ComponentCreatorAnnotation> getCreatorAnnotations(TypeElement type) {
        return (ImmutableSet)ComponentCreatorAnnotation.stream().filter(cca -> MoreElements.isAnnotationPresent(type, cca.annotation())).collect(DaggerStreams.toImmutableSet());
    }

    private static Stream<ComponentCreatorAnnotation> stream() {
        return DaggerStreams.valuesOf(ComponentCreatorAnnotation.class);
    }

    private static Collector<ComponentCreatorAnnotation, ?, ImmutableSet<Class<? extends Annotation>>> toAnnotationClasses() {
        return Collectors.mapping(ComponentCreatorAnnotation::annotation, DaggerStreams.toImmutableSet());
    }
}

