/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentDescriptorFactory;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.ComponentValidator;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;

final class ComponentHjarProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final SourceFileGenerator<ComponentDescriptor> componentGenerator;

    @Inject
    ComponentHjarProcessingStep(Messager messager, ComponentValidator componentValidator, ComponentCreatorValidator creatorValidator, ComponentDescriptorFactory componentDescriptorFactory, SourceFileGenerator<ComponentDescriptor> componentGenerator) {
        super(MoreElements::asType);
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.creatorValidator = creatorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.componentGenerator = componentGenerator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return Sets.union(ComponentAnnotation.rootComponentAnnotations(), ComponentCreatorAnnotation.rootComponentCreatorAnnotations());
    }

    @Override
    protected void process(TypeElement element, ImmutableSet<Class<? extends Annotation>> annotations) {
        if (!Collections.disjoint(annotations, ComponentAnnotation.rootComponentAnnotations())) {
            this.processRootComponent(element);
        }
        if (!Collections.disjoint(annotations, ComponentCreatorAnnotation.rootComponentCreatorAnnotations())) {
            this.processRootCreator(element);
        }
    }

    private void processRootComponent(TypeElement element) {
        ValidationReport<TypeElement> validationReport = this.componentValidator.validate(element);
        validationReport.printMessagesTo(this.messager);
        if (validationReport.isClean()) {
            this.componentGenerator.generate(this.componentDescriptorFactory.rootComponentDescriptor(element), this.messager);
        }
    }

    private void processRootCreator(TypeElement creator) {
        this.creatorValidator.validate(MoreElements.asType(creator)).printMessagesTo(this.messager);
    }
}

