/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.AnnotationSpecs;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.model.Key;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.Modifier;

abstract class SwitchingProviders {
    private static final int MAX_CASES_PER_SWITCH = 100;
    private static final long MAX_CASES_PER_CLASS = 10000L;
    private static final TypeVariableName T = TypeVariableName.get((String)"T");
    private final Map<Key, SwitchingProviderBuilder> switchingProviderBuilders = new LinkedHashMap<Key, SwitchingProviderBuilder>();
    private final ComponentImplementation componentImplementation;
    private final ClassName owningComponent;
    private final DaggerTypes types;
    private final UniqueNameSet switchingProviderNames = new UniqueNameSet();

    SwitchingProviders(ComponentImplementation componentImplementation, DaggerTypes types) {
        this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.owningComponent = ((ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation)).name();
    }

    protected abstract TypeSpec createSwitchingProviderType(TypeSpec.Builder var1);

    protected final Expression getProviderExpression(SwitchCase switchCase) {
        return this.switchingProviderBuilders.computeIfAbsent(switchCase.key(), key -> this.getSwitchingProviderBuilder()).getProviderExpression(switchCase);
    }

    private SwitchingProviderBuilder getSwitchingProviderBuilder() {
        if ((long)this.switchingProviderBuilders.size() % 10000L == 0L) {
            String name = this.switchingProviderNames.getUniqueName("SwitchingProvider");
            SwitchingProviderBuilder switchingProviderBuilder = new SwitchingProviderBuilder(this.owningComponent.nestedClass(name));
            this.componentImplementation.addSwitchingProvider((Supplier<TypeSpec>)((Supplier)() -> switchingProviderBuilder.build()));
            return switchingProviderBuilder;
        }
        return (SwitchingProviderBuilder)Iterables.getLast(this.switchingProviderBuilders.values());
    }

    private final class SwitchingProviderBuilder {
        private final Map<Integer, CodeBlock> switchCases = new TreeMap<Integer, CodeBlock>();
        private final Map<Key, Integer> switchIds = new HashMap<Key, Integer>();
        private final ClassName switchingProviderType;

        SwitchingProviderBuilder(ClassName switchingProviderType) {
            this.switchingProviderType = (ClassName)Preconditions.checkNotNull((Object)switchingProviderType);
        }

        Expression getProviderExpression(SwitchCase switchCase) {
            Key key = switchCase.key();
            if (!this.switchIds.containsKey(key)) {
                int switchId = this.switchIds.size();
                this.switchIds.put(key, switchId);
                this.switchCases.put(switchId, this.createSwitchCaseCodeBlock(switchCase));
            }
            return switchCase.getProviderExpression(this.switchingProviderType, this.switchIds.get(key));
        }

        private CodeBlock createSwitchCaseCodeBlock(SwitchCase switchCase) {
            CodeBlock instanceCodeBlock = switchCase.getReturnExpression(this.switchingProviderType).box(SwitchingProviders.this.types).codeBlock();
            return CodeBlock.builder().add("case $L: // $L \n", new Object[]{this.switchIds.get(switchCase.key()), switchCase.key()}).addStatement("return ($T) $L", new Object[]{T, instanceCodeBlock}).build();
        }

        private TypeSpec build() {
            return SwitchingProviders.this.createSwitchingProviderType(TypeSpec.classBuilder((ClassName)this.switchingProviderType).addTypeVariable(T).addSuperinterface((TypeName)TypeNames.providerOf((TypeName)T)).addMethods(this.getMethods()));
        }

        private ImmutableList<MethodSpec> getMethods() {
            ImmutableList<CodeBlock> switchCodeBlockPartitions = this.switchCodeBlockPartitions();
            if (switchCodeBlockPartitions.size() == 1) {
                return ImmutableList.of((Object)MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addAnnotation(Override.class).returns((TypeName)T).addCode((CodeBlock)Iterables.getOnlyElement(switchCodeBlockPartitions)).build());
            }
            MethodSpec.Builder routerMethod = MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)T).beginControlFlow("switch (id / $L)", new Object[]{100});
            ImmutableList.Builder getMethods = ImmutableList.builder();
            for (int i = 0; i < switchCodeBlockPartitions.size(); ++i) {
                MethodSpec method = MethodSpec.methodBuilder((String)("get" + i)).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).returns((TypeName)T).addCode((CodeBlock)switchCodeBlockPartitions.get(i)).build();
                getMethods.add((Object)method);
                routerMethod.addStatement("case $L: return $N()", new Object[]{i, method});
            }
            routerMethod.addStatement("default: throw new $T(id)", new Object[]{AssertionError.class}).endControlFlow();
            return getMethods.add((Object)routerMethod.build()).build();
        }

        private ImmutableList<CodeBlock> switchCodeBlockPartitions() {
            return (ImmutableList)Lists.partition((List)ImmutableList.copyOf(this.switchCases.values()), (int)100).stream().map(partitionCases -> CodeBlock.builder().beginControlFlow("switch (id)", new Object[0]).add(CodeBlocks.concat(partitionCases)).addStatement("default: throw new $T(id)", new Object[]{AssertionError.class}).endControlFlow().build()).collect(DaggerStreams.toImmutableList());
        }
    }

    static interface SwitchCase {
        public Key key();

        public Expression getReturnExpression(ClassName var1);

        public Expression getProviderExpression(ClassName var1, int var2);
    }
}

