/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.binding.FrameworkTypeMapper;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.CodeBlocks;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.writing.AnonymousProviderCreationExpression;
import dagger.internal.codegen.writing.BindingExpression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentInstanceBindingExpression;
import dagger.internal.codegen.writing.ComponentMethodBindingExpression;
import dagger.internal.codegen.writing.ComponentProvisionBindingExpression;
import dagger.internal.codegen.writing.ComponentRequirementBindingExpression;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.DelegateBindingExpression;
import dagger.internal.codegen.writing.DelegatingFrameworkInstanceCreationExpression;
import dagger.internal.codegen.writing.DependencyMethodProducerCreationExpression;
import dagger.internal.codegen.writing.DependencyMethodProviderCreationExpression;
import dagger.internal.codegen.writing.DerivedFromFrameworkInstanceBindingExpression;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.writing.FrameworkInstanceBindingExpression;
import dagger.internal.codegen.writing.FrameworkInstanceSupplier;
import dagger.internal.codegen.writing.ImmediateFutureBindingExpression;
import dagger.internal.codegen.writing.InjectionOrProvisionProviderCreationExpression;
import dagger.internal.codegen.writing.InnerSwitchingProviders;
import dagger.internal.codegen.writing.InstanceFactoryCreationExpression;
import dagger.internal.codegen.writing.MapBindingExpression;
import dagger.internal.codegen.writing.MapFactoryCreationExpression;
import dagger.internal.codegen.writing.MemberSelect;
import dagger.internal.codegen.writing.MembersInjectionBindingExpression;
import dagger.internal.codegen.writing.MembersInjectionMethods;
import dagger.internal.codegen.writing.MembersInjectorProviderCreationExpression;
import dagger.internal.codegen.writing.MethodBindingExpression;
import dagger.internal.codegen.writing.OptionalBindingExpression;
import dagger.internal.codegen.writing.OptionalFactories;
import dagger.internal.codegen.writing.OptionalFactoryInstanceCreationExpression;
import dagger.internal.codegen.writing.ParentComponent;
import dagger.internal.codegen.writing.PerComponentImplementation;
import dagger.internal.codegen.writing.PrivateMethodBindingExpression;
import dagger.internal.codegen.writing.ProducerCreationExpression;
import dagger.internal.codegen.writing.ProducerFromProviderCreationExpression;
import dagger.internal.codegen.writing.ProducerNodeInstanceBindingExpression;
import dagger.internal.codegen.writing.ProviderInstanceBindingExpression;
import dagger.internal.codegen.writing.SetBindingExpression;
import dagger.internal.codegen.writing.SetFactoryCreationExpression;
import dagger.internal.codegen.writing.SimpleMethodBindingExpression;
import dagger.internal.codegen.writing.SubcomponentCreatorBindingExpression;
import dagger.internal.codegen.writing.TopLevel;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.shaded.auto.common.MoreTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

@PerComponentImplementation
public final class ComponentBindingExpressions {
    private final Optional<ComponentBindingExpressions> parent;
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final ComponentImplementation topLevelComponentImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final OptionalFactories optionalFactories;
    private final DaggerTypes types;
    private final DaggerElements elements;
    private final SourceVersion sourceVersion;
    private final CompilerOptions compilerOptions;
    private final MembersInjectionMethods membersInjectionMethods;
    private final InnerSwitchingProviders innerSwitchingProviders;
    private final Map<BindingRequest, BindingExpression> expressions = new HashMap<BindingRequest, BindingExpression>();
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    ComponentBindingExpressions(@ParentComponent Optional<ComponentBindingExpressions> parent, BindingGraph graph, ComponentImplementation componentImplementation, @TopLevel ComponentImplementation topLevelComponentImplementation, ComponentRequirementExpressions componentRequirementExpressions, OptionalFactories optionalFactories, DaggerTypes types, DaggerElements elements, SourceVersion sourceVersion, CompilerOptions compilerOptions, KotlinMetadataUtil metadataUtil) {
        this.parent = parent;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.topLevelComponentImplementation = topLevelComponentImplementation;
        this.componentRequirementExpressions = (ComponentRequirementExpressions)Preconditions.checkNotNull((Object)componentRequirementExpressions);
        this.optionalFactories = (OptionalFactories)Preconditions.checkNotNull((Object)optionalFactories);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.elements = (DaggerElements)Preconditions.checkNotNull((Object)elements);
        this.sourceVersion = (SourceVersion)((Object)Preconditions.checkNotNull((Object)((Object)sourceVersion)));
        this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
        this.membersInjectionMethods = new MembersInjectionMethods(componentImplementation, this, graph, elements, types, metadataUtil);
        this.innerSwitchingProviders = new InnerSwitchingProviders(componentImplementation, this, types);
        this.metadataUtil = metadataUtil;
    }

    public Expression getDependencyExpression(BindingRequest request, ClassName requestingClass) {
        return this.getBindingExpression(request).getDependencyExpression(requestingClass);
    }

    Expression getDependencyExpressionForComponentMethod(BindingRequest request, ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation componentImplementation) {
        return this.getBindingExpression(request).getDependencyExpressionForComponentMethod(componentMethod, componentImplementation);
    }

    CodeBlock getCreateMethodArgumentsCodeBlock(ContributionBinding binding) {
        return CodeBlocks.makeParametersCodeBlock(this.getCreateMethodArgumentsCodeBlocks(binding));
    }

    private ImmutableList<CodeBlock> getCreateMethodArgumentsCodeBlocks(ContributionBinding binding) {
        ImmutableList.Builder arguments = ImmutableList.builder();
        if (binding.requiresModuleInstance()) {
            arguments.add((Object)this.componentRequirementExpressions.getExpressionDuringInitialization(ComponentRequirement.forModule(binding.contributingModule().get().asType()), this.componentImplementation.name()));
        }
        binding.dependencies().stream().map(dependency -> ComponentBindingExpressions.frameworkRequest(binding, dependency)).map(request -> this.getDependencyExpression((BindingRequest)request, this.componentImplementation.name())).map(Expression::codeBlock).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        return arguments.build();
    }

    private static BindingRequest frameworkRequest(ContributionBinding binding, DependencyRequest dependency) {
        FrameworkType frameworkType = FrameworkTypeMapper.forBindingType(binding.bindingType()).getFrameworkType(dependency.kind());
        return BindingRequest.bindingRequest(dependency.key(), frameworkType);
    }

    Expression getDependencyArgumentExpression(DependencyRequest dependencyRequest, ClassName requestingClass) {
        TypeMirror dependencyType = dependencyRequest.key().type();
        BindingRequest bindingRequest = BindingRequest.bindingRequest(dependencyRequest);
        Expression dependencyExpression = this.getDependencyExpression(bindingRequest, requestingClass);
        if (dependencyRequest.kind().equals((Object)RequestKind.INSTANCE) && !Accessibility.isTypeAccessibleFrom(dependencyType, requestingClass.packageName()) && Accessibility.isRawTypeAccessible(dependencyType, requestingClass.packageName())) {
            return dependencyExpression.castTo(this.types.erasure(dependencyType));
        }
        return dependencyExpression;
    }

    public MethodSpec getComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        Preconditions.checkArgument((boolean)componentMethod.dependencyRequest().isPresent());
        BindingRequest request = BindingRequest.bindingRequest(componentMethod.dependencyRequest().get());
        MethodSpec.Builder method = MethodSpec.overriding((ExecutableElement)componentMethod.methodElement(), (DeclaredType)MoreTypes.asDeclared(this.graph.componentTypeElement().asType()), (Types)this.types);
        CodeBlock methodBody = this.getBindingExpression(request).getComponentMethodImplementation(componentMethod, this.componentImplementation);
        return method.addCode(methodBody).build();
    }

    BindingExpression getBindingExpression(BindingRequest request) {
        if (this.expressions.containsKey(request)) {
            return this.expressions.get(request);
        }
        ResolvedBindings resolvedBindings = this.graph.resolvedBindings(request);
        if (resolvedBindings != null && !resolvedBindings.bindingsOwnedBy(this.graph.componentDescriptor()).isEmpty()) {
            BindingExpression expression = this.createBindingExpression(resolvedBindings.binding(), request);
            this.expressions.put(request, expression);
            return expression;
        }
        Preconditions.checkArgument((boolean)this.parent.isPresent(), (String)"no expression found for %s", (Object)request);
        return this.parent.get().getBindingExpression(request);
    }

    private BindingExpression createBindingExpression(Binding binding, BindingRequest request) {
        switch (binding.bindingType()) {
            case MEMBERS_INJECTION: {
                Preconditions.checkArgument((boolean)request.isRequestKind(RequestKind.MEMBERS_INJECTION));
                return new MembersInjectionBindingExpression((MembersInjectionBinding)binding, this.membersInjectionMethods);
            }
            case PROVISION: {
                return this.provisionBindingExpression((ContributionBinding)binding, request);
            }
            case PRODUCTION: {
                return this.productionBindingExpression((ContributionBinding)binding, request);
            }
        }
        throw new AssertionError(binding);
    }

    private BindingExpression frameworkInstanceBindingExpression(ContributionBinding binding) {
        FrameworkFieldInitializer.FrameworkInstanceCreationExpression frameworkInstanceCreationExpression;
        Optional<Object> staticMethod = this.useStaticFactoryCreation(binding) ? MemberSelect.staticFactoryCreation(binding) : Optional.empty();
        FrameworkFieldInitializer.FrameworkInstanceCreationExpression frameworkInstanceCreationExpression2 = frameworkInstanceCreationExpression = binding.scope().isPresent() ? this.scope(binding, this.frameworkInstanceCreationExpression(binding)) : this.frameworkInstanceCreationExpression(binding);
        FrameworkInstanceSupplier frameworkInstanceSupplier = staticMethod.isPresent() ? staticMethod::get : new FrameworkFieldInitializer(this.componentImplementation, binding, frameworkInstanceCreationExpression);
        switch (binding.bindingType()) {
            case PROVISION: {
                return new ProviderInstanceBindingExpression(binding, frameworkInstanceSupplier, this.types, this.elements);
            }
            case PRODUCTION: {
                return new ProducerNodeInstanceBindingExpression(binding, frameworkInstanceSupplier, this.types, this.elements, this.componentImplementation);
            }
        }
        throw new AssertionError((Object)("invalid binding type: " + (Object)((Object)binding.bindingType())));
    }

    private FrameworkFieldInitializer.FrameworkInstanceCreationExpression scope(ContributionBinding binding, FrameworkFieldInitializer.FrameworkInstanceCreationExpression unscoped) {
        return () -> CodeBlock.of((String)"$T.provider($L)", (Object[])new Object[]{binding.scope().get().isReusable() ? TypeNames.SINGLE_CHECK : TypeNames.DOUBLE_CHECK, unscoped.creationExpression()});
    }

    private FrameworkFieldInitializer.FrameworkInstanceCreationExpression frameworkInstanceCreationExpression(ContributionBinding binding) {
        switch (binding.kind()) {
            case COMPONENT: {
                return new InstanceFactoryCreationExpression(() -> CodeBlock.of((String)"($T) this", (Object[])new Object[]{binding.key().type()}));
            }
            case BOUND_INSTANCE: {
                return this.instanceFactoryCreationExpression(binding, ComponentRequirement.forBoundInstance(binding));
            }
            case COMPONENT_DEPENDENCY: {
                return this.instanceFactoryCreationExpression(binding, ComponentRequirement.forDependency(binding.key().type()));
            }
            case COMPONENT_PROVISION: {
                return new DependencyMethodProviderCreationExpression(binding, this.componentImplementation, this.componentRequirementExpressions, this.compilerOptions, this.graph);
            }
            case SUBCOMPONENT_CREATOR: {
                return new AnonymousProviderCreationExpression(binding, this, this.componentImplementation.name());
            }
            case INJECTION: 
            case PROVISION: {
                return new InjectionOrProvisionProviderCreationExpression(binding, this);
            }
            case COMPONENT_PRODUCTION: {
                return new DependencyMethodProducerCreationExpression(binding, this.componentImplementation, this.componentRequirementExpressions, this.graph);
            }
            case PRODUCTION: {
                return new ProducerCreationExpression(binding, this);
            }
            case MULTIBOUND_SET: {
                return new SetFactoryCreationExpression(binding, this.componentImplementation, this, this.graph);
            }
            case MULTIBOUND_MAP: {
                return new MapFactoryCreationExpression(binding, this.componentImplementation, this, this.graph, this.elements);
            }
            case DELEGATE: {
                return new DelegatingFrameworkInstanceCreationExpression(binding, this.componentImplementation, this);
            }
            case OPTIONAL: {
                return new OptionalFactoryInstanceCreationExpression(this.optionalFactories, binding, this.componentImplementation, this);
            }
            case MEMBERS_INJECTOR: {
                return new MembersInjectorProviderCreationExpression((ProvisionBinding)binding, this);
            }
        }
        throw new AssertionError(binding);
    }

    private InstanceFactoryCreationExpression instanceFactoryCreationExpression(ContributionBinding binding, ComponentRequirement componentRequirement) {
        return new InstanceFactoryCreationExpression(binding.nullableType().isPresent(), () -> this.componentRequirementExpressions.getExpressionDuringInitialization(componentRequirement, this.componentImplementation.name()));
    }

    private BindingExpression provisionBindingExpression(ContributionBinding binding, BindingRequest request) {
        if (!request.requestKind().isPresent()) {
            Verify.verify((boolean)request.frameworkType().get().equals((Object)FrameworkType.PRODUCER_NODE), (String)"expected a PRODUCER_NODE: %s", (Object)request);
            return this.producerFromProviderBindingExpression(binding);
        }
        RequestKind requestKind = request.requestKind().get();
        Key key = request.key();
        switch (requestKind) {
            case INSTANCE: {
                return this.instanceBindingExpression(binding);
            }
            case PROVIDER: {
                return this.providerBindingExpression(binding);
            }
            case LAZY: 
            case PRODUCED: 
            case PROVIDER_OF_LAZY: {
                return new DerivedFromFrameworkInstanceBindingExpression(key, FrameworkType.PROVIDER, requestKind, this, this.types);
            }
            case PRODUCER: {
                return this.producerFromProviderBindingExpression(binding);
            }
            case FUTURE: {
                return new ImmediateFutureBindingExpression(key, this, this.types, this.sourceVersion);
            }
            case MEMBERS_INJECTION: {
                throw new IllegalArgumentException();
            }
        }
        throw new AssertionError();
    }

    private BindingExpression productionBindingExpression(ContributionBinding binding, BindingRequest request) {
        if (request.frameworkType().isPresent()) {
            return this.frameworkInstanceBindingExpression(binding);
        }
        RequestKind requestKind = request.requestKind().get();
        return new DerivedFromFrameworkInstanceBindingExpression(request.key(), FrameworkType.PRODUCER_NODE, requestKind, this, this.types);
    }

    private BindingExpression providerBindingExpression(ContributionBinding binding) {
        if (binding.kind().equals((Object)BindingKind.DELEGATE) && !this.needsCaching(binding)) {
            return new DelegateBindingExpression(binding, RequestKind.PROVIDER, this, this.types, this.elements);
        }
        if (this.compilerOptions.fastInit(this.topLevelComponentImplementation.componentDescriptor().typeElement()) && this.frameworkInstanceCreationExpression(binding).useInnerSwitchingProvider() && !(this.instanceBindingExpression(binding) instanceof DerivedFromFrameworkInstanceBindingExpression)) {
            return this.wrapInMethod(binding, BindingRequest.bindingRequest(binding.key(), RequestKind.PROVIDER), this.innerSwitchingProviders.newBindingExpression(binding));
        }
        return this.frameworkInstanceBindingExpression(binding);
    }

    private FrameworkInstanceBindingExpression producerFromProviderBindingExpression(ContributionBinding binding) {
        Preconditions.checkArgument((boolean)binding.bindingType().equals((Object)BindingType.PROVISION));
        return new ProducerNodeInstanceBindingExpression(binding, new FrameworkFieldInitializer(this.componentImplementation, binding, new ProducerFromProviderCreationExpression(binding, this.componentImplementation, this)), this.types, this.elements, this.componentImplementation);
    }

    private BindingExpression instanceBindingExpression(ContributionBinding binding) {
        Optional<BindingExpression> maybeDirectInstanceExpression = this.unscopedDirectInstanceExpression(binding);
        if (this.canUseDirectInstanceExpression(binding) && maybeDirectInstanceExpression.isPresent()) {
            BindingExpression directInstanceExpression = maybeDirectInstanceExpression.get();
            return directInstanceExpression.requiresMethodEncapsulation() || this.needsCaching(binding) ? this.wrapInMethod(binding, BindingRequest.bindingRequest(binding.key(), RequestKind.INSTANCE), directInstanceExpression) : directInstanceExpression;
        }
        return new DerivedFromFrameworkInstanceBindingExpression(binding.key(), FrameworkType.PROVIDER, RequestKind.INSTANCE, this, this.types);
    }

    private Optional<BindingExpression> unscopedDirectInstanceExpression(ContributionBinding binding) {
        switch (binding.kind()) {
            case DELEGATE: {
                return Optional.of(new DelegateBindingExpression(binding, RequestKind.INSTANCE, this, this.types, this.elements));
            }
            case COMPONENT: {
                return Optional.of(new ComponentInstanceBindingExpression(binding, this.componentImplementation.name()));
            }
            case COMPONENT_DEPENDENCY: {
                return Optional.of(new ComponentRequirementBindingExpression(binding, ComponentRequirement.forDependency(binding.key().type()), this.componentRequirementExpressions));
            }
            case COMPONENT_PROVISION: {
                return Optional.of(new ComponentProvisionBindingExpression((ProvisionBinding)binding, this.graph, this.componentRequirementExpressions, this.compilerOptions));
            }
            case SUBCOMPONENT_CREATOR: {
                return Optional.of(new SubcomponentCreatorBindingExpression(binding, this.componentImplementation.getSubcomponentCreatorSimpleName(binding.key())));
            }
            case MULTIBOUND_SET: {
                return Optional.of(new SetBindingExpression((ProvisionBinding)binding, this.graph, this, this.types, this.elements));
            }
            case MULTIBOUND_MAP: {
                return Optional.of(new MapBindingExpression((ProvisionBinding)binding, this.graph, this, this.types, this.elements));
            }
            case OPTIONAL: {
                return Optional.of(new OptionalBindingExpression((ProvisionBinding)binding, this, this.types, this.sourceVersion));
            }
            case BOUND_INSTANCE: {
                return Optional.of(new ComponentRequirementBindingExpression(binding, ComponentRequirement.forBoundInstance(binding), this.componentRequirementExpressions));
            }
            case INJECTION: 
            case PROVISION: {
                return Optional.of(new SimpleMethodBindingExpression((ProvisionBinding)binding, this.compilerOptions, this, this.membersInjectionMethods, this.componentRequirementExpressions, this.types, this.elements, this.sourceVersion, this.metadataUtil));
            }
            case MEMBERS_INJECTOR: {
                return Optional.empty();
            }
            case COMPONENT_PRODUCTION: 
            case PRODUCTION: 
            case MEMBERS_INJECTION: {
                throw new IllegalArgumentException(binding.kind().toString());
            }
        }
        throw new AssertionError();
    }

    private boolean useStaticFactoryCreation(ContributionBinding binding) {
        return !this.compilerOptions.fastInit(this.topLevelComponentImplementation.componentDescriptor().typeElement()) || binding.kind().equals((Object)BindingKind.MULTIBOUND_MAP) || binding.kind().equals((Object)BindingKind.MULTIBOUND_SET);
    }

    private boolean canUseDirectInstanceExpression(ContributionBinding binding) {
        return !this.needsCaching(binding) || this.compilerOptions.fastInit(this.topLevelComponentImplementation.componentDescriptor().typeElement());
    }

    BindingExpression wrapInMethod(ContributionBinding binding, BindingRequest request, BindingExpression bindingExpression) {
        if (bindingExpression instanceof MethodBindingExpression) {
            return bindingExpression;
        }
        MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy = this.methodImplementationStrategy(binding, request);
        Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod = this.graph.componentDescriptor().firstMatchingComponentMethod(request);
        if (matchingComponentMethod.isPresent()) {
            ComponentDescriptor.ComponentMethodDescriptor componentMethod = matchingComponentMethod.get();
            return new ComponentMethodBindingExpression(request, binding, methodImplementationStrategy, bindingExpression, this.componentImplementation, componentMethod, this.types);
        }
        return new PrivateMethodBindingExpression(request, binding, methodImplementationStrategy, bindingExpression, this.componentImplementation, this.types);
    }

    private MethodBindingExpression.MethodImplementationStrategy methodImplementationStrategy(ContributionBinding binding, BindingRequest request) {
        if (this.compilerOptions.fastInit(this.topLevelComponentImplementation.componentDescriptor().typeElement())) {
            if (request.isRequestKind(RequestKind.PROVIDER)) {
                return MethodBindingExpression.MethodImplementationStrategy.SINGLE_CHECK;
            }
            if (request.isRequestKind(RequestKind.INSTANCE) && this.needsCaching(binding)) {
                return binding.scope().get().isReusable() ? MethodBindingExpression.MethodImplementationStrategy.SINGLE_CHECK : MethodBindingExpression.MethodImplementationStrategy.DOUBLE_CHECK;
            }
        }
        return MethodBindingExpression.MethodImplementationStrategy.SIMPLE;
    }

    private boolean needsCaching(ContributionBinding binding) {
        if (!binding.scope().isPresent()) {
            return false;
        }
        if (binding.kind().equals((Object)BindingKind.DELEGATE)) {
            return DelegateBindingExpression.isBindsScopeStrongerThanDependencyScope(binding, this.graph);
        }
        return true;
    }
}

