/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PackageNameCompressor {
    static final String LEGEND_HEADER = "\n\n======================\nFull classname legend:\n======================\n";
    static final String LEGEND_FOOTER = "========================\nEnd of classname legend:\n========================\n";
    private static final ImmutableSet<String> PACKAGES_SKIPPED_IN_LEGEND = ImmutableSet.of((Object)"java.lang.", (Object)"java.util.");
    private static final Splitter PACKAGE_SPLITTER = Splitter.on((char)'.');
    private static final Joiner PACKAGE_JOINER = Joiner.on((char)'.');
    private static final Pattern CLASSNAME_PATTERN = Pattern.compile("[\\W](([a-z_0-9]++[.])++[A-Z][\\w$]++)");

    static String compressPackagesInMessage(String input) {
        Matcher matcher = CLASSNAME_PATTERN.matcher(input);
        HashSet<String> names = new HashSet<String>();
        while (matcher.find()) {
            String name = matcher.group(1);
            names.add(name);
        }
        Map<String, String> replacementMap = PackageNameCompressor.shortenNames(names);
        if (replacementMap.isEmpty()) {
            return input;
        }
        int longestKey = replacementMap.keySet().stream().max(Comparator.comparing(String::length)).get().length();
        String replacedString = input;
        StringBuilder legendBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : replacementMap.entrySet()) {
            String shortName = entry.getKey();
            String fullName = entry.getValue();
            replacedString = replacedString.replace(fullName, shortName);
            String prefix = fullName.substring(0, fullName.length() - shortName.length());
            if (PACKAGES_SKIPPED_IN_LEGEND.contains((Object)prefix) && !shortName.contains(".")) continue;
            legendBuilder.append(shortName).append(": ").append(Strings.repeat((String)" ", (int)(longestKey - shortName.length()))).append(fullName).append("\n");
        }
        if (legendBuilder.length() != 0) {
            legendBuilder.insert(0, LEGEND_HEADER);
            legendBuilder.append(LEGEND_FOOTER);
            return replacedString + legendBuilder;
        }
        return replacedString;
    }

    /*
     * Exception decompiling
     */
    private static Map<String, String> shortenNames(Collection<String> names) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[DOLOOP]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PackageNameCompressor() {
    }
}

