/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.langmodel;

import com.google.common.base.Preconditions;
import dagger.shaded.auto.common.MoreElements;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.SimpleTypeVisitor8;

public final class Accessibility {
    private static final TypeVisitor<Boolean, Optional<String>> RAW_TYPE_ACCESSIBILITY_VISITOR = new SimpleTypeVisitor8<Boolean, Optional<String>>(){

        @Override
        protected Boolean defaultAction(TypeMirror e, Optional<String> requestingPackage) {
            return Accessibility.isTypeAccessibleFrom(e, requestingPackage);
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Optional<String> requestingPackage) {
            return Accessibility.isElementAccessibleFrom(t.asElement(), requestingPackage);
        }
    };

    public static boolean isTypePubliclyAccessible(TypeMirror type) {
        return type.accept(new TypeAccessibilityVisitor(), null);
    }

    public static boolean isTypeAccessibleFrom(TypeMirror type, String packageName) {
        return type.accept(new TypeAccessibilityVisitor(packageName), null);
    }

    private static boolean isTypeAccessibleFrom(TypeMirror type, Optional<String> packageName) {
        return type.accept(new TypeAccessibilityVisitor(packageName), null);
    }

    public static boolean isElementPubliclyAccessible(Element element) {
        return element.accept(new ElementAccessibilityVisitor(), null);
    }

    public static boolean isElementAccessibleFrom(Element element, String packageName) {
        return element.accept(new ElementAccessibilityVisitor(packageName), null);
    }

    private static boolean isElementAccessibleFrom(Element element, Optional<String> packageName) {
        return element.accept(new ElementAccessibilityVisitor(packageName), null);
    }

    public static boolean isElementAccessibleFromOwnPackage(Element element) {
        return Accessibility.isElementAccessibleFrom(element, MoreElements.getPackage(element).getQualifiedName().toString());
    }

    public static boolean isRawTypeAccessible(TypeMirror type, String requestingPackage) {
        return type.accept(RAW_TYPE_ACCESSIBILITY_VISITOR, Optional.of(requestingPackage));
    }

    public static boolean isRawTypePubliclyAccessible(TypeMirror type) {
        return type.accept(RAW_TYPE_ACCESSIBILITY_VISITOR, Optional.empty());
    }

    private Accessibility() {
    }

    private static final class ElementAccessibilityVisitor
    extends SimpleElementVisitor6<Boolean, Void> {
        final Optional<String> packageName;

        ElementAccessibilityVisitor() {
            this(Optional.empty());
        }

        ElementAccessibilityVisitor(String packageName) {
            this(Optional.of(packageName));
        }

        ElementAccessibilityVisitor(Optional<String> packageName) {
            this.packageName = packageName;
        }

        @Override
        public Boolean visitPackage(PackageElement element, Void p) {
            return true;
        }

        @Override
        public Boolean visitType(TypeElement element, Void p) {
            switch (element.getNestingKind()) {
                case MEMBER: {
                    return this.accessibleMember(element);
                }
                case TOP_LEVEL: {
                    return this.accessibleModifiers(element);
                }
                case ANONYMOUS: 
                case LOCAL: {
                    return false;
                }
            }
            throw new AssertionError();
        }

        boolean accessibleMember(Element element) {
            if (!element.getEnclosingElement().accept(this, null).booleanValue()) {
                return false;
            }
            return this.accessibleModifiers(element);
        }

        boolean accessibleModifiers(Element element) {
            if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return true;
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return false;
            }
            return this.packageName.isPresent() && MoreElements.getPackage(element).getQualifiedName().contentEquals(this.packageName.get());
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterElement element, Void p) {
            throw new IllegalArgumentException("It does not make sense to check the accessibility of a type parameter");
        }

        @Override
        public Boolean visitExecutable(ExecutableElement element, Void p) {
            return this.accessibleMember(element);
        }

        @Override
        public Boolean visitVariable(VariableElement element, Void p) {
            ElementKind kind = element.getKind();
            Preconditions.checkArgument((boolean)kind.isField(), (String)"checking a variable that isn't a field: %s", (Object)((Object)kind));
            return this.accessibleMember(element);
        }
    }

    private static final class TypeAccessibilityVisitor
    extends SimpleTypeVisitor6<Boolean, Void> {
        final Optional<String> packageName;

        TypeAccessibilityVisitor() {
            this(Optional.empty());
        }

        TypeAccessibilityVisitor(String packageName) {
            this(Optional.of(packageName));
        }

        TypeAccessibilityVisitor(Optional<String> packageName) {
            this.packageName = packageName;
        }

        boolean isAccessible(TypeMirror type) {
            return type.accept(this, null);
        }

        @Override
        public Boolean visitNoType(NoType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void p) {
            if (!this.isAccessible(type.getEnclosingType())) {
                return false;
            }
            if (!Accessibility.isElementAccessibleFrom(type.asElement(), this.packageName)) {
                return false;
            }
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                if (this.isAccessible(typeMirror)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType type, Void p) {
            return type.getComponentType().accept(this, null);
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitNull(NullType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable type, Void p) {
            return true;
        }

        @Override
        public Boolean visitWildcard(WildcardType type, Void p) {
            if (type.getExtendsBound() != null && !this.isAccessible(type.getExtendsBound())) {
                return false;
            }
            if (type.getSuperBound() != null && !this.isAccessible(type.getSuperBound())) {
                return false;
            }
            return true;
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void p) {
            throw new IllegalArgumentException(String.format("%s of kind %s should not be checked for accessibility", new Object[]{type, type.getKind()}));
        }
    }
}

