/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclarationFormatter;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingNode;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ChildFactoryMethodEdgeImpl;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentNodeImpl;
import dagger.internal.codegen.binding.DependencyEdgeImpl;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.binding.SubcomponentCreatorBindingEdgeImpl;
import dagger.internal.codegen.extension.DaggerGraphs;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.model.BindingGraph;
import dagger.model.BindingGraphProxies;
import dagger.model.BindingKind;
import dagger.model.ComponentPath;
import dagger.model.DependencyRequest;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class BindingGraphConverter {
    private final BindingDeclarationFormatter bindingDeclarationFormatter;

    @Inject
    BindingGraphConverter(BindingDeclarationFormatter bindingDeclarationFormatter) {
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
    }

    public dagger.model.BindingGraph convert(BindingGraph bindingGraph) {
        MutableNetwork network = Converter.convert(bindingGraph, this.bindingDeclarationFormatter);
        if (!bindingGraph.isFullBindingGraph()) {
            DaggerGraphs.unreachableNodes((Graph)network.asGraph(), (Object)this.rootComponentNode((Network<BindingGraph.Node, BindingGraph.Edge>)network)).forEach(arg_0 -> ((MutableNetwork)network).removeNode(arg_0));
        }
        return BindingGraphProxies.bindingGraph((Network<BindingGraph.Node, BindingGraph.Edge>)network, bindingGraph.isFullBindingGraph());
    }

    private BindingGraph.ComponentNode rootComponentNode(Network<BindingGraph.Node, BindingGraph.Edge> network) {
        return (BindingGraph.ComponentNode)Iterables.find((Iterable)network.nodes(), node -> node instanceof BindingGraph.ComponentNode && node.componentPath().atRoot());
    }

    private static final class Converter {
        private final Deque<BindingGraph> bindingGraphPath = new ArrayDeque<BindingGraph>();
        private final Deque<ComponentPath> componentPaths = new ArrayDeque<ComponentPath>();
        private final BindingDeclarationFormatter bindingDeclarationFormatter;
        private final MutableNetwork<BindingGraph.Node, BindingGraph.Edge> network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        private final Set<BindingNode> bindings = new HashSet<BindingNode>();
        private final Map<ResolvedBindings, ImmutableSet<BindingNode>> resolvedBindingsMap = new HashMap<ResolvedBindings, ImmutableSet<BindingNode>>();

        private static MutableNetwork<BindingGraph.Node, BindingGraph.Edge> convert(BindingGraph graph, BindingDeclarationFormatter bindingDeclarationFormatter) {
            Converter converter = new Converter(bindingDeclarationFormatter);
            converter.visitRootComponent(graph);
            return converter.network;
        }

        private Converter(BindingDeclarationFormatter bindingDeclarationFormatter) {
            this.bindingDeclarationFormatter = bindingDeclarationFormatter;
        }

        private void visitRootComponent(BindingGraph graph) {
            this.visitComponent(graph, null);
        }

        private void visitComponent(BindingGraph graph, BindingGraph.ComponentNode parentComponent) {
            this.bindingGraphPath.addLast(graph);
            ComponentPath graphPath = ComponentPath.create((Iterable)((Iterable)this.bindingGraphPath.stream().map(BindingGraph::componentTypeElement).collect(DaggerStreams.toImmutableList())));
            this.componentPaths.addLast(graphPath);
            BindingGraph.ComponentNode currentComponent = ComponentNodeImpl.create(this.componentPath(), graph.componentDescriptor());
            this.network.addNode((Object)currentComponent);
            for (ComponentDescriptor.ComponentMethodDescriptor entryPointMethod : graph.componentDescriptor().entryPointMethods()) {
                this.visitEntryPoint(currentComponent, entryPointMethod.dependencyRequest().get());
            }
            for (ResolvedBindings resolvedBindings : graph.resolvedBindings()) {
                for (BindingNode binding : this.bindingNodes(resolvedBindings)) {
                    if (this.bindings.add(binding)) {
                        this.network.addNode((Object)binding);
                        for (DependencyRequest dependencyRequest : binding.dependencies()) {
                            this.addDependencyEdges((BindingGraph.Node)binding, dependencyRequest);
                        }
                    }
                    if (!binding.kind().equals((Object)BindingKind.SUBCOMPONENT_CREATOR) || !binding.componentPath().equals((Object)currentComponent.componentPath())) continue;
                    this.network.addEdge((Object)binding, (Object)this.subcomponentNode(binding.key().type(), graph), (Object)new SubcomponentCreatorBindingEdgeImpl(resolvedBindings.subcomponentDeclarations()));
                }
            }
            if (this.bindingGraphPath.size() > 1) {
                BindingGraph parent = (BindingGraph)Iterators.get(this.bindingGraphPath.descendingIterator(), (int)1);
                parent.componentDescriptor().getFactoryMethodForChildComponent(graph.componentDescriptor()).ifPresent(childFactoryMethod -> this.visitSubcomponentFactoryMethod(parentComponent, currentComponent, childFactoryMethod.methodElement()));
            }
            for (BindingGraph child : graph.subgraphs()) {
                this.visitComponent(child, currentComponent);
            }
            Verify.verify((boolean)this.bindingGraphPath.removeLast().equals(graph));
            Verify.verify((boolean)this.componentPaths.removeLast().equals((Object)graphPath));
        }

        private void visitEntryPoint(BindingGraph.ComponentNode componentNode, DependencyRequest entryPoint) {
            this.addDependencyEdges((BindingGraph.Node)componentNode, entryPoint);
        }

        private void visitSubcomponentFactoryMethod(BindingGraph.ComponentNode parentComponent, BindingGraph.ComponentNode currentComponent, ExecutableElement factoryMethod) {
            this.network.addEdge((Object)parentComponent, (Object)currentComponent, (Object)new ChildFactoryMethodEdgeImpl(factoryMethod));
        }

        private ComponentPath componentPath() {
            return this.componentPaths.getLast();
        }

        private ComponentPath pathFromRootToAncestor(TypeElement ancestor) {
            for (ComponentPath componentPath : this.componentPaths) {
                if (!componentPath.currentComponent().equals(ancestor)) continue;
                return componentPath;
            }
            throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.getQualifiedName(), this.componentPath()));
        }

        private BindingGraph graphForAncestor(TypeElement ancestor) {
            for (BindingGraph graph : this.bindingGraphPath) {
                if (!graph.componentTypeElement().equals(ancestor)) continue;
                return graph;
            }
            throw new IllegalArgumentException(String.format("%s is not in the current path: %s", ancestor.getQualifiedName(), this.componentPath()));
        }

        private void addDependencyEdges(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            ResolvedBindings dependencies = this.resolvedDependencies(source, dependencyRequest);
            if (dependencies.isEmpty()) {
                this.addDependencyEdge(source, dependencyRequest, (BindingGraph.Node)this.missingBindingNode(dependencies));
            } else {
                for (BindingNode dependency : this.bindingNodes(dependencies)) {
                    this.addDependencyEdge(source, dependencyRequest, (BindingGraph.Node)dependency);
                }
            }
        }

        private void addDependencyEdge(BindingGraph.Node source, DependencyRequest dependencyRequest, BindingGraph.Node dependency) {
            this.network.addNode((Object)dependency);
            if (!this.hasDependencyEdge(source, dependency, dependencyRequest)) {
                this.network.addEdge((Object)source, (Object)dependency, (Object)new DependencyEdgeImpl(dependencyRequest, source instanceof BindingGraph.ComponentNode));
            }
        }

        private boolean hasDependencyEdge(BindingGraph.Node source, BindingGraph.Node dependency, DependencyRequest dependencyRequest) {
            for (BindingGraph.Edge edge : this.network.edgesConnecting((Object)source, (Object)dependency)) {
                if (!(edge instanceof BindingGraph.DependencyEdge) || !((BindingGraph.DependencyEdge)edge).dependencyRequest().equals(dependencyRequest)) continue;
                return true;
            }
            return false;
        }

        private ResolvedBindings resolvedDependencies(BindingGraph.Node source, DependencyRequest dependencyRequest) {
            return this.graphForAncestor(source.componentPath().currentComponent()).resolvedBindings(BindingRequest.bindingRequest(dependencyRequest));
        }

        private ImmutableSet<BindingNode> bindingNodes(ResolvedBindings resolvedBindings) {
            return this.resolvedBindingsMap.computeIfAbsent(resolvedBindings, this::uncachedBindingNodes);
        }

        private ImmutableSet<BindingNode> uncachedBindingNodes(ResolvedBindings resolvedBindings) {
            ImmutableSet.Builder bindingNodes = ImmutableSet.builder();
            resolvedBindings.allBindings().asMap().forEach((component, bindings) -> {
                for (Binding binding : bindings) {
                    bindingNodes.add((Object)this.bindingNode(resolvedBindings, binding, (TypeElement)component));
                }
            });
            return bindingNodes.build();
        }

        private BindingNode bindingNode(ResolvedBindings resolvedBindings, Binding binding, TypeElement owningComponent) {
            return BindingNode.create(this.pathFromRootToAncestor(owningComponent), binding, resolvedBindings.multibindingDeclarations(), resolvedBindings.optionalBindingDeclarations(), resolvedBindings.subcomponentDeclarations(), this.bindingDeclarationFormatter);
        }

        private BindingGraph.MissingBinding missingBindingNode(ResolvedBindings dependencies) {
            return BindingGraphProxies.missingBindingNode(ComponentPath.create((Iterable)ImmutableList.of((Object)this.componentPath().rootComponent())), dependencies.key());
        }

        private BindingGraph.ComponentNode subcomponentNode(TypeMirror subcomponentBuilderType, BindingGraph graph) {
            TypeElement subcomponentBuilderElement = MoreTypes.asTypeElement(subcomponentBuilderType);
            ComponentDescriptor subcomponent = graph.componentDescriptor().getChildComponentWithBuilderType(subcomponentBuilderElement);
            return ComponentNodeImpl.create(this.componentPath().childPath(subcomponent.typeElement()), subcomponent);
        }
    }
}

