/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.graph.Traverser;
import dagger.internal.codegen.binding.AutoValue_BindingGraph;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.ResolvedBindings;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.model.Key;
import dagger.model.RequestKind;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

@AutoValue
public abstract class BindingGraph {
    private static final Traverser<BindingGraph> SUBGRAPH_TRAVERSER = Traverser.forTree(BindingGraph::subgraphs);

    public abstract ComponentDescriptor componentDescriptor();

    public abstract ImmutableMap<Key, ResolvedBindings> contributionBindings();

    public abstract ImmutableMap<Key, ResolvedBindings> membersInjectionBindings();

    public final ResolvedBindings resolvedBindings(BindingRequest request) {
        return request.isRequestKind(RequestKind.MEMBERS_INJECTION) ? (ResolvedBindings)this.membersInjectionBindings().get((Object)request.key()) : (ResolvedBindings)this.contributionBindings().get((Object)request.key());
    }

    public final Iterable<ResolvedBindings> resolvedBindings() {
        return Iterables.concat((Iterable)this.membersInjectionBindings().values(), (Iterable)this.contributionBindings().values());
    }

    public abstract ImmutableList<BindingGraph> subgraphs();

    public TypeElement componentTypeElement() {
        return this.componentDescriptor().typeElement();
    }

    abstract ImmutableSet<ModuleDescriptor> ownedModules();

    public ImmutableSet<TypeElement> ownedModuleTypes() {
        return FluentIterable.from(this.ownedModules()).transform(ModuleDescriptor::moduleElement).toSet();
    }

    public abstract Optional<ExecutableElement> factoryMethod();

    public ImmutableMap<ComponentRequirement, VariableElement> factoryMethodParameters() {
        Preconditions.checkState((boolean)this.factoryMethod().isPresent());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (VariableElement variableElement : this.factoryMethod().get().getParameters()) {
            builder.put((Object)ComponentRequirement.forModule(variableElement.asType()), (Object)variableElement);
        }
        return builder.build();
    }

    public ImmutableSet<ComponentRequirement> componentRequirements() {
        ImmutableSet<TypeElement> requiredModules = this.requiredModuleElements();
        ImmutableSet.Builder requirements = ImmutableSet.builder();
        this.componentDescriptor().requirements().stream().filter(requirement -> !requirement.kind().isModule() || requiredModules.contains((Object)requirement.typeElement())).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        if (this.factoryMethod().isPresent()) {
            requirements.addAll((Iterable)this.factoryMethodParameters().keySet());
        }
        return requirements.build();
    }

    private ImmutableSet<TypeElement> requiredModuleElements() {
        return (ImmutableSet)DaggerStreams.stream((Iterable)SUBGRAPH_TRAVERSER.depthFirstPostOrder((Object)this)).flatMap(graph -> graph.bindingModules().stream()).filter(arg_0 -> this.ownedModuleTypes().contains(arg_0)).collect(DaggerStreams.toImmutableSet());
    }

    protected ImmutableSet<TypeElement> bindingModules() {
        return (ImmutableSet)this.contributionBindings().values().stream().flatMap(bindings -> bindings.contributionBindings().stream()).map(BindingDeclaration::contributingModule).flatMap(DaggerStreams.presentValues()).collect(DaggerStreams.toImmutableSet());
    }

    public ImmutableSet<ComponentDescriptor> componentDescriptors() {
        return FluentIterable.from((Iterable)SUBGRAPH_TRAVERSER.depthFirstPreOrder((Object)this)).transform(BindingGraph::componentDescriptor).toSet();
    }

    abstract boolean isFullBindingGraph();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public static BindingGraph create(ComponentDescriptor componentDescriptor, Map<Key, ResolvedBindings> resolvedContributionBindingsMap, Map<Key, ResolvedBindings> resolvedMembersInjectionBindings, List<BindingGraph> subgraphs, Set<ModuleDescriptor> ownedModules, Optional<ExecutableElement> factoryMethod, boolean isFullBindingGraph) {
        BindingGraph.checkForDuplicates(subgraphs);
        return new AutoValue_BindingGraph(componentDescriptor, (ImmutableMap<Key, ResolvedBindings>)ImmutableMap.copyOf(resolvedContributionBindingsMap), (ImmutableMap<Key, ResolvedBindings>)ImmutableMap.copyOf(resolvedMembersInjectionBindings), (ImmutableList<BindingGraph>)ImmutableList.copyOf(subgraphs), (ImmutableSet<ModuleDescriptor>)ImmutableSet.copyOf(ownedModules), factoryMethod, isFullBindingGraph);
    }

    private static final void checkForDuplicates(Iterable<BindingGraph> graphs) {
        Map duplicateGraphs = Maps.filterValues((Map)Multimaps.index(graphs, graph -> graph.componentDescriptor().typeElement()).asMap(), overlapping -> overlapping.size() > 1);
        if (!duplicateGraphs.isEmpty()) {
            throw new IllegalArgumentException("Expected no duplicates: " + duplicateGraphs);
        }
    }
}

