/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.internal.codegen.$;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.SetType;
import dagger.model.DependencyRequest;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

@AutoValue
abstract class ProductionBinding
extends ContributionBinding {
    ProductionBinding() {
    }

    @Override
    public BindingType bindingType() {
        return BindingType.PRODUCTION;
    }

    abstract Optional<ProductionBinding> unresolved();

    @Override
    ImmutableSet<DependencyRequest> implicitDependencies() {
        return Stream.of(this.executorRequest(), this.monitorRequest()).filter(Optional::isPresent).map(Optional::get).collect(DaggerStreams.toImmutableSet());
    }

    abstract Optional<ProductionKind> productionKind();

    abstract ImmutableList<? extends TypeMirror> thrownTypes();

    abstract Optional<DependencyRequest> executorRequest();

    abstract Optional<DependencyRequest> monitorRequest();

    @Override
    boolean requiresModuleInstance() {
        return super.requiresModuleInstance();
    }

    static Builder builder() {
        return new $.AutoValue_ProductionBinding.Builder().explicitDependencies((Iterable<DependencyRequest>)ImmutableList.of()).thrownTypes((Iterable<? extends TypeMirror>)ImmutableList.of());
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @AutoValue.Builder
    @CanIgnoreReturnValue
    static abstract class Builder
    extends ContributionBinding.Builder<ProductionBinding, Builder> {
        Builder() {
        }

        @Override
        Builder dependencies(Iterable<DependencyRequest> dependencies) {
            return this.explicitDependencies(dependencies);
        }

        abstract Builder explicitDependencies(Iterable<DependencyRequest> var1);

        abstract Builder productionKind(ProductionKind var1);

        @Override
        abstract Builder unresolved(ProductionBinding var1);

        abstract Builder thrownTypes(Iterable<? extends TypeMirror> var1);

        abstract Builder executorRequest(DependencyRequest var1);

        abstract Builder monitorRequest(DependencyRequest var1);
    }

    static enum ProductionKind {
        IMMEDIATE,
        FUTURE,
        SET_OF_FUTURE;


        static ProductionKind fromProducesMethod(ExecutableElement producesMethod) {
            if (DaggerTypes.isFutureType(producesMethod.getReturnType())) {
                return FUTURE;
            }
            if (ContributionType.fromBindingMethod(producesMethod).equals((Object)ContributionType.SET_VALUES) && DaggerTypes.isFutureType(SetType.from(producesMethod.getReturnType()).elementType())) {
                return SET_OF_FUTURE;
            }
            return IMMEDIATE;
        }
    }
}

