/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.errorprone.annotations.FormatMethod;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerGraphs;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.ValidationType;
import dagger.model.Binding;
import dagger.model.BindingGraph;
import dagger.model.ComponentPath;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class DiagnosticReporterFactory {
    private final DaggerTypes types;
    private final Messager messager;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final CompilerOptions compilerOptions;

    @Inject
    DiagnosticReporterFactory(DaggerTypes types, Messager messager, DependencyRequestFormatter dependencyRequestFormatter, CompilerOptions compilerOptions) {
        this.types = types;
        this.messager = messager;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.compilerOptions = compilerOptions;
    }

    DiagnosticReporterImpl reporter(BindingGraph graph, BindingGraphPlugin plugin) {
        return new DiagnosticReporterImpl(graph, plugin.pluginName());
    }

    private static <K, V> java.util.function.Function<K, V> memoize(java.util.function.Function<K, V> uncached) {
        Function uncachedAsBaseFunction = uncached::apply;
        LoadingCache cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)uncachedAsBaseFunction));
        java.util.function.Function<Object, Object> memoized = arg_0 -> ((LoadingCache)cache).apply(arg_0);
        return memoized;
    }

    static /* synthetic */ java.util.function.Function access$000(java.util.function.Function x0) {
        return DiagnosticReporterFactory.memoize(x0);
    }

    final class DiagnosticReporterImpl
    implements DiagnosticReporter {
        private final java.util.function.Function<TypeElement, Iterable<TypeElement>> supertypes = DiagnosticReporterFactory.access$000(component -> Iterables.transform(DiagnosticReporterFactory.this.types.supertypes(component.asType()), type -> MoreTypes.asTypeElement(type)));
        private final Table<BindingGraph.MaybeBinding, BindingGraph.DependencyEdge, ImmutableList<BindingGraph.Node>> shortestPaths = HashBasedTable.create();
        private final BindingGraph graph;
        private final String plugin;
        private final TypeElement rootComponent;
        private final ImmutableSet.Builder<Diagnostic.Kind> reportedDiagnosticKinds = ImmutableSet.builder();

        DiagnosticReporterImpl(BindingGraph graph, String plugin) {
            this.graph = graph;
            this.plugin = plugin;
            this.rootComponent = graph.rootComponentNode().componentPath().currentComponent();
        }

        ImmutableSet<Diagnostic.Kind> reportedDiagnosticKinds() {
            return this.reportedDiagnosticKinds.build();
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat) {
            StringBuilder message = new StringBuilder(messageFormat);
            this.appendComponentPathUnlessAtRoot(message, (BindingGraph.Node)componentNode);
            this.printMessage(diagnosticKind, message, this.rootComponent);
        }

        @FormatMethod
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportComponent(diagnosticKind, componentNode, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String message) {
            this.printMessage(diagnosticKind, message + new DiagnosticInfo(binding), this.rootComponent);
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.MaybeBinding binding, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportBinding(diagnosticKind, binding, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            this.printMessage(diagnosticKind, message + new DiagnosticInfo(dependencyEdge), this.rootComponent);
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportDependency(diagnosticKind, dependencyEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String message) {
            this.printMessage(diagnosticKind, message, childFactoryMethodEdge.factoryMethod());
        }

        public void reportSubcomponentFactoryMethod(Diagnostic.Kind diagnosticKind, BindingGraph.ChildFactoryMethodEdge childFactoryMethodEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportSubcomponentFactoryMethod(diagnosticKind, childFactoryMethodEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        private String formatMessage(String messageFormat, Object firstArg, Object[] moreArgs) {
            return String.format(messageFormat, Lists.asList((Object)firstArg, (Object[])moreArgs).toArray());
        }

        private BindingGraph.Node source(BindingGraph.Edge edge) {
            return (BindingGraph.Node)this.graph.network().incidentNodes((Object)edge).source();
        }

        void printMessage(Diagnostic.Kind diagnosticKind, CharSequence message, @NullableDecl Element elementToReport) {
            if (this.graph.isModuleBindingGraph()) {
                if (DiagnosticReporterFactory.this.compilerOptions.moduleBindingValidationType().equals((Object)ValidationType.NONE)) {
                    return;
                }
                if (diagnosticKind.equals((Object)Diagnostic.Kind.ERROR)) {
                    diagnosticKind = DiagnosticReporterFactory.this.compilerOptions.moduleBindingValidationType().diagnosticKind().get();
                }
            }
            this.reportedDiagnosticKinds.add((Object)diagnosticKind);
            StringBuilder fullMessage = new StringBuilder();
            this.appendBracketPrefix(fullMessage, this.plugin);
            if (elementToReport != null && !DaggerElements.elementEncloses(this.rootComponent, elementToReport)) {
                this.appendBracketPrefix(fullMessage, DaggerElements.elementToString(elementToReport));
                elementToReport = this.rootComponent;
            }
            DiagnosticReporterFactory.this.messager.printMessage(diagnosticKind, fullMessage.append(message), elementToReport);
        }

        private void appendComponentPathUnlessAtRoot(StringBuilder message, BindingGraph.Node node) {
            if (!node.componentPath().equals((Object)this.graph.rootComponentNode().componentPath())) {
                message.append(String.format(" [%s]", node.componentPath()));
            }
        }

        private void appendBracketPrefix(StringBuilder message, String prefix) {
            message.append(String.format("[%s] ", prefix));
        }

        private final class DiagnosticInfo {
            final ImmutableList<BindingGraph.DependencyEdge> dependencyTrace;
            final ImmutableSet<BindingGraph.DependencyEdge> requests;
            final ImmutableSet<BindingGraph.DependencyEdge> entryPoints;
            private final Formatter<BindingGraph.DependencyEdge> entryPointFormatter = new Formatter<BindingGraph.DependencyEdge>(){

                @Override
                public String format(BindingGraph.DependencyEdge object) {
                    Element requestElement = (Element)object.dependencyRequest().requestElement().get();
                    StringBuilder element = new StringBuilder(DaggerElements.elementToString(requestElement));
                    ComponentPath componentPath = DiagnosticReporterImpl.this.source((BindingGraph.Edge)object).componentPath();
                    if (!componentPath.atRoot() || !requestElement.getEnclosingElement().equals(DiagnosticReporterImpl.this.rootComponent)) {
                        element.append(String.format(" [%s]", componentPath));
                    }
                    return element.toString();
                }
            };

            DiagnosticInfo(BindingGraph.MaybeBinding binding) {
                this.entryPoints = DiagnosticReporterImpl.this.graph.entryPointEdgesDependingOnBinding(binding);
                this.requests = this.requests(binding);
                this.dependencyTrace = this.dependencyTrace(binding, this.entryPoints);
            }

            DiagnosticInfo(BindingGraph.DependencyEdge dependencyEdge) {
                this.requests = ImmutableSet.of((Object)dependencyEdge);
                ImmutableList.Builder dependencyTraceBuilder = ImmutableList.builder();
                dependencyTraceBuilder.add((Object)dependencyEdge);
                if (dependencyEdge.isEntryPoint()) {
                    this.entryPoints = ImmutableSet.of((Object)dependencyEdge);
                } else {
                    Binding binding = (Binding)DiagnosticReporterImpl.this.source((BindingGraph.Edge)dependencyEdge);
                    this.entryPoints = DiagnosticReporterImpl.this.graph.entryPointEdgesDependingOnBinding((BindingGraph.MaybeBinding)binding);
                    dependencyTraceBuilder.addAll(this.dependencyTrace((BindingGraph.MaybeBinding)binding, this.entryPoints));
                }
                this.dependencyTrace = dependencyTraceBuilder.build();
            }

            public String toString() {
                ImmutableSet requestsToPrint;
                StringBuilder message;
                StringBuilder stringBuilder = message = DiagnosticReporterImpl.this.graph.isModuleBindingGraph() ? new StringBuilder() : new StringBuilder(this.dependencyTrace.size() * 100);
                if (!DiagnosticReporterImpl.this.graph.isModuleBindingGraph()) {
                    this.dependencyTrace.forEach(edge -> DiagnosticReporterFactory.this.dependencyRequestFormatter.appendFormatLine(message, edge.dependencyRequest()));
                    if (!this.dependencyTrace.isEmpty()) {
                        DiagnosticReporterImpl.this.appendComponentPathUnlessAtRoot(message, DiagnosticReporterImpl.this.source((BindingGraph.Edge)Iterables.getLast(this.dependencyTrace)));
                    }
                }
                if (!(requestsToPrint = this.requests.stream().filter(request -> DiagnosticReporterImpl.this.graph.isModuleBindingGraph() || !request.isEntryPoint() && !this.isTracedRequest((BindingGraph.DependencyEdge)request)).map(request -> request.dependencyRequest().requestElement()).flatMap(DaggerStreams.presentValues()).collect(DaggerStreams.toImmutableSet())).isEmpty()) {
                    message.append("\nIt is").append(DiagnosticReporterImpl.this.graph.isModuleBindingGraph() ? " " : " also ").append("requested at:");
                    DaggerElements.elementFormatter().formatIndentedList(message, (Iterable<Element>)requestsToPrint, 1);
                }
                if (!DiagnosticReporterImpl.this.graph.isModuleBindingGraph() && this.entryPoints.size() > 1) {
                    message.append("\nThe following other entry points also depend on it:");
                    this.entryPointFormatter.formatIndentedList(message, (Iterable)this.entryPoints.stream().filter(entryPoint -> !entryPoint.equals(Iterables.getLast(this.dependencyTrace))).sorted(this.rootComponentFirst().thenComparing(this.nearestComponentSupertypeFirst()).thenComparing(this.requestElementDeclarationOrder())).collect(DaggerStreams.toImmutableList()), 1);
                }
                return message.toString();
            }

            private boolean isTracedRequest(BindingGraph.DependencyEdge request) {
                return !this.dependencyTrace.isEmpty() && request.equals(this.dependencyTrace.get(0));
            }

            ImmutableList<BindingGraph.DependencyEdge> dependencyTrace(BindingGraph.MaybeBinding binding, ImmutableSet<BindingGraph.DependencyEdge> entryPoints) {
                if (entryPoints.isEmpty()) {
                    return ImmutableList.of();
                }
                BindingGraph.DependencyEdge entryPointForTrace = Collections.min(entryPoints, this.rootComponentFirst().thenComparing(this.shortestDependencyPathFirst(binding)).thenComparing(this.nearestComponentSupertypeFirst()).thenComparing(this.requestElementDeclarationOrder()));
                ImmutableList<BindingGraph.Node> shortestBindingPath = this.shortestPathFromEntryPoint(entryPointForTrace, binding);
                Verify.verify((!shortestBindingPath.isEmpty() ? 1 : 0) != 0, (String)"no dependency path from %s to %s in %s", (Object)entryPointForTrace, (Object)binding, (Object)DiagnosticReporterImpl.this.graph);
                ImmutableList.Builder dependencyTrace = ImmutableList.builder();
                dependencyTrace.add((Object)entryPointForTrace);
                for (int i = 0; i < shortestBindingPath.size() - 1; ++i) {
                    Set dependenciesBetween = DiagnosticReporterImpl.this.graph.network().edgesConnecting((Object)((BindingGraph.Node)shortestBindingPath.get(i)), (Object)((BindingGraph.Node)shortestBindingPath.get(i + 1)));
                    dependencyTrace.add((Object)((BindingGraph.DependencyEdge)Iterables.get((Iterable)dependenciesBetween, (int)0)));
                }
                return dependencyTrace.build().reverse();
            }

            ImmutableSet<BindingGraph.DependencyEdge> requests(BindingGraph.MaybeBinding binding) {
                return DiagnosticReporterImpl.this.graph.network().inEdges((Object)binding).stream().flatMap(DaggerStreams.instancesOf(BindingGraph.DependencyEdge.class)).filter(edge -> edge.dependencyRequest().requestElement().isPresent()).sorted(this.requestEnclosingTypeName().thenComparing(this.requestElementDeclarationOrder())).collect(DaggerStreams.toImmutableSet());
            }

            Comparator<BindingGraph.DependencyEdge> rootComponentFirst() {
                return Comparator.comparingInt(entryPoint -> DiagnosticReporterImpl.this.source((BindingGraph.Edge)entryPoint).componentPath().components().size());
            }

            Comparator<BindingGraph.DependencyEdge> shortestDependencyPathFirst(BindingGraph.MaybeBinding binding) {
                return Comparator.comparing(entryPoint -> this.shortestPathFromEntryPoint((BindingGraph.DependencyEdge)entryPoint, binding).size());
            }

            ImmutableList<BindingGraph.Node> shortestPathFromEntryPoint(BindingGraph.DependencyEdge entryPoint, BindingGraph.MaybeBinding binding) {
                return DiagnosticReporterImpl.this.shortestPaths.row((Object)binding).computeIfAbsent(entryPoint, ep -> DaggerGraphs.shortestPath(node -> Iterables.filter((Iterable)DiagnosticReporterImpl.this.graph.network().successors(node), BindingGraph.MaybeBinding.class::isInstance), (BindingGraph.Node)DiagnosticReporterImpl.this.graph.network().incidentNodes(ep).target(), binding));
            }

            Comparator<BindingGraph.DependencyEdge> nearestComponentSupertypeFirst() {
                return Comparator.comparingInt(entryPoint -> Iterables.indexOf((Iterable)((Iterable)DiagnosticReporterImpl.this.supertypes.apply(this.componentContainingEntryPoint((BindingGraph.DependencyEdge)entryPoint))), (Predicate)Predicates.equalTo((Object)this.typeDeclaringEntryPoint((BindingGraph.DependencyEdge)entryPoint))));
            }

            TypeElement componentContainingEntryPoint(BindingGraph.DependencyEdge entryPoint) {
                return DiagnosticReporterImpl.this.source((BindingGraph.Edge)entryPoint).componentPath().currentComponent();
            }

            TypeElement typeDeclaringEntryPoint(BindingGraph.DependencyEdge entryPoint) {
                return MoreElements.asType(((Element)entryPoint.dependencyRequest().requestElement().get()).getEnclosingElement());
            }

            Comparator<BindingGraph.DependencyEdge> requestEnclosingTypeName() {
                return Comparator.comparing(edge -> DaggerElements.closestEnclosingTypeElement((Element)edge.dependencyRequest().requestElement().get()).getQualifiedName().toString());
            }

            Comparator<BindingGraph.DependencyEdge> requestElementDeclarationOrder() {
                return Comparator.comparing(edge -> (Element)edge.dependencyRequest().requestElement().get(), DaggerElements.DECLARATION_ORDER);
            }
        }
    }
}

