/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Reusable;
import dagger.internal.codegen.AutoValue_ComponentValidator_ComponentValidationReport;
import dagger.internal.codegen.ComponentAnnotation;
import dagger.internal.codegen.ComponentCreatorAnnotation;
import dagger.internal.codegen.ComponentCreatorValidator;
import dagger.internal.codegen.ComponentKind;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequestFactory;
import dagger.internal.codegen.DependencyRequestValidator;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.MembersInjectionValidator;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ModuleAnnotation;
import dagger.internal.codegen.ModuleKind;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ValidationReport;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.producers.CancellationPolicy;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;

final class ComponentValidator {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final ModuleValidator moduleValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final MembersInjectionValidator membersInjectionValidator;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final DependencyRequestFactory dependencyRequestFactory;

    @Inject
    ComponentValidator(DaggerElements elements, DaggerTypes types, ModuleValidator moduleValidator, ComponentCreatorValidator creatorValidator, DependencyRequestValidator dependencyRequestValidator, MembersInjectionValidator membersInjectionValidator, MethodSignatureFormatter methodSignatureFormatter, DependencyRequestFactory dependencyRequestFactory) {
        this.elements = elements;
        this.types = types;
        this.moduleValidator = moduleValidator;
        this.creatorValidator = creatorValidator;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.membersInjectionValidator = membersInjectionValidator;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.dependencyRequestFactory = dependencyRequestFactory;
    }

    public ComponentValidationReport validate(TypeElement subject, Set<? extends Element> validatedSubcomponents, Set<? extends Element> validatedSubcomponentCreators) {
        ImmutableSet<Element> allSubcomponents;
        ValidationReport.Builder<TypeElement> report = ValidationReport.about(subject);
        ImmutableSet<ComponentKind> componentKinds = ComponentKind.getComponentKinds(subject);
        if (componentKinds.size() > 1) {
            String error = "Components may not be annotated with more than one component annotation: found " + ComponentKind.annotationsFor(componentKinds);
            report.addError(error, subject);
            allSubcomponents = ImmutableSet.of();
        } else {
            ComponentKind componentKind = (ComponentKind)((Object)Iterables.getOnlyElement(componentKinds));
            ComponentAnnotation componentAnnotation = ComponentAnnotation.anyComponentAnnotation(subject).get();
            allSubcomponents = this.validate(subject, componentAnnotation, componentKind, validatedSubcomponents, validatedSubcomponentCreators, report);
        }
        return new AutoValue_ComponentValidator_ComponentValidationReport(allSubcomponents, report.build());
    }

    private ImmutableSet<Element> validate(TypeElement subject, ComponentAnnotation componentAnnotation, ComponentKind componentKind, Set<? extends Element> validatedSubcomponents, Set<? extends Element> validatedSubcomponentCreators, ValidationReport.Builder<TypeElement> report) {
        Optional<AnnotationMirror> reusableAnnotation;
        ImmutableList creators;
        if (MoreElements.isAnnotationPresent(subject, CancellationPolicy.class) && !componentKind.isProducer()) {
            report.addError("@CancellationPolicy may only be applied to production components and subcomponents", subject);
        }
        if (!(subject.getKind().equals((Object)ElementKind.INTERFACE) || subject.getKind().equals((Object)ElementKind.CLASS) && subject.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            report.addError(String.format("@%s may only be applied to an interface or abstract class", componentKind.annotation().getSimpleName()), subject);
        }
        if ((creators = ComponentCreatorAnnotation.creatorAnnotationsFor(componentAnnotation).stream().flatMap(annotation -> ConfigurationAnnotations.enclosedAnnotatedTypes(subject, annotation).stream()).collect(DaggerStreams.toImmutableList())).size() > 1) {
            report.addError(String.format(ErrorMessages.componentMessagesFor(componentKind).moreThanOne(), creators), subject);
        }
        if ((reusableAnnotation = DaggerElements.getAnnotationMirror(subject, Reusable.class)).isPresent()) {
            report.addError("@Reusable cannot be applied to components or subcomponents", subject, reusableAnnotation.get());
        }
        DeclaredType subjectType = MoreTypes.asDeclared(subject.asType());
        LinkedHashMultimap referencedSubcomponents = LinkedHashMultimap.create();
        MoreElements.getLocalAndInheritedMethods(subject, this.types, this.elements).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).forEachOrdered(arg_0 -> this.lambda$validate$2(subjectType, report, componentKind, componentAnnotation, (SetMultimap)referencedSubcomponents, validatedSubcomponentCreators, arg_0));
        this.checkConflictingEntryPoints(report);
        Maps.filterValues((Map)referencedSubcomponents.asMap(), methods -> methods.size() > 1).forEach((subcomponent, methods) -> report.addError(String.format(ErrorMessages.ComponentCreatorMessages.moreThanOneRefToSubcomponent(), subcomponent, methods), subject));
        ComponentValidator.validateComponentDependencies(report, componentAnnotation.dependencyTypes());
        report.addSubreport(this.moduleValidator.validateReferencedModules(subject, componentAnnotation.annotation(), componentKind.legalModuleKinds(), new HashSet<TypeElement>()));
        ImmutableSet.Builder allSubcomponents = ImmutableSet.builder().addAll((Iterable)referencedSubcomponents.keySet());
        for (Element subcomponent2 : Sets.difference((Set)referencedSubcomponents.keySet(), validatedSubcomponents)) {
            ComponentValidationReport subreport = this.validate(MoreElements.asType(subcomponent2), validatedSubcomponents, validatedSubcomponentCreators);
            report.addItems((Iterable<ValidationReport.Item>)subreport.report().items());
            allSubcomponents.addAll(subreport.referencedSubcomponents());
        }
        return allSubcomponents.build();
    }

    private void checkConflictingEntryPoints(ValidationReport.Builder<TypeElement> report) {
        DeclaredType componentType = MoreTypes.asDeclared(report.getSubject().asType());
        HashMultimap entryPointMethods = HashMultimap.create();
        ElementFilter.methodsIn(this.elements.getAllMembers(report.getSubject())).stream().filter(method -> this.isEntryPoint((ExecutableElement)method, MoreTypes.asExecutable(this.types.asMemberOf(componentType, (Element)method)))).forEach(arg_0 -> this.lambda$checkConflictingEntryPoints$6((SetMultimap)entryPointMethods, arg_0));
        for (Set methods : Multimaps.asMap((SetMultimap)entryPointMethods).values()) {
            if (this.distinctKeys(methods, report.getSubject()).size() <= 1) continue;
            this.reportConflictingEntryPoints(methods, report);
        }
    }

    private boolean isEntryPoint(ExecutableElement method, ExecutableType methodType) {
        return method.getModifiers().contains((Object)Modifier.ABSTRACT) && method.getParameters().isEmpty() && !methodType.getReturnType().getKind().equals((Object)TypeKind.VOID) && methodType.getTypeVariables().isEmpty();
    }

    private ImmutableSet<Key> distinctKeys(Set<ExecutableElement> methods, TypeElement component) {
        return methods.stream().map(method -> this.dependencyRequest((ExecutableElement)method, component)).map(DependencyRequest::key).collect(DaggerStreams.toImmutableSet());
    }

    private DependencyRequest dependencyRequest(ExecutableElement method, TypeElement component) {
        ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(component.asType()), method));
        return ComponentKind.forAnnotatedElement(component).get().isProducer() ? this.dependencyRequestFactory.forComponentProductionMethod(method, methodType) : this.dependencyRequestFactory.forComponentProvisionMethod(method, methodType);
    }

    private void addMethodUnlessOverridden(ExecutableElement method, Set<ExecutableElement> methods) {
        if (methods.stream().noneMatch(existingMethod -> this.overridesAsDeclared((ExecutableElement)existingMethod, method))) {
            methods.removeIf(existingMethod -> this.overridesAsDeclared(method, (ExecutableElement)existingMethod));
            methods.add(method);
        }
    }

    private boolean overridesAsDeclared(ExecutableElement overridder, ExecutableElement overridden) {
        return this.elements.overrides(overridder, overridden, MoreElements.asType(overridder.getEnclosingElement()));
    }

    private void reportConflictingEntryPoints(Collection<ExecutableElement> methods, ValidationReport.Builder<TypeElement> report) {
        Verify.verify((methods.stream().map(Element::getEnclosingElement).distinct().count() == (long)methods.size() ? 1 : 0) != 0, (String)"expected each method to be declared on a different type: %s", methods);
        StringBuilder message = new StringBuilder("conflicting entry point declarations:");
        this.methodSignatureFormatter.typedFormatter(MoreTypes.asDeclared(report.getSubject().asType())).formatIndentedList(message, (Iterable<ExecutableElement>)ImmutableList.sortedCopyOf(Comparator.comparing(method -> MoreElements.asType(method.getEnclosingElement()).getQualifiedName().toString()), methods), 1);
        report.addError(message.toString());
    }

    private void validateSubcomponentMethod(ValidationReport.Builder<TypeElement> report, final ComponentKind subcomponentKind, ExecutableElement method, List<? extends VariableElement> parameters, List<? extends TypeMirror> parameterTypes, TypeMirror returnType, Optional<AnnotationMirror> subcomponentAnnotation) {
        ImmutableSet<TypeElement> moduleTypes = ComponentAnnotation.componentAnnotation(subcomponentAnnotation.get()).modules();
        ImmutableSet<TypeElement> transitiveModules = ConfigurationAnnotations.getTransitiveModules(this.types, this.elements, moduleTypes);
        HashSet variableTypes = Sets.newHashSet();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            TypeMirror parameterType = parameterTypes.get(i);
            Optional<TypeElement> moduleType = parameterType.accept(new SimpleTypeVisitor6<Optional<TypeElement>, Void>(){

                @Override
                protected Optional<TypeElement> defaultAction(TypeMirror e, Void p) {
                    return Optional.empty();
                }

                @Override
                public Optional<TypeElement> visitDeclared(DeclaredType t, Void p) {
                    for (ModuleKind moduleKind : subcomponentKind.legalModuleKinds()) {
                        if (!MoreElements.isAnnotationPresent(t.asElement(), moduleKind.annotation())) continue;
                        return Optional.of(MoreTypes.asTypeElement(t));
                    }
                    return Optional.empty();
                }
            }, null);
            if (moduleType.isPresent()) {
                if (variableTypes.contains(moduleType.get())) {
                    report.addError(String.format("A module may only occur once an an argument in a Subcomponent factory method, but %s was already passed.", moduleType.get().getQualifiedName()), parameter);
                }
                if (!transitiveModules.contains((Object)moduleType.get())) {
                    report.addError(String.format("%s is present as an argument to the %s factory method, but is not one of the modules used to implement the subcomponent.", moduleType.get().getQualifiedName(), MoreTypes.asTypeElement(returnType).getQualifiedName()), method);
                }
                variableTypes.add(moduleType.get());
                continue;
            }
            report.addError(String.format("Subcomponent factory methods may only accept modules, but %s is not.", parameterType), parameter);
        }
    }

    private void validateSubcomponentCreatorMethod(ValidationReport.Builder<TypeElement> report, ExecutableElement method, List<? extends VariableElement> parameters, TypeMirror returnType, Set<? extends Element> validatedSubcomponentCreators) {
        TypeElement creatorElement;
        if (!parameters.isEmpty()) {
            report.addError(ErrorMessages.ComponentCreatorMessages.builderMethodRequiresNoArgs(), method);
        }
        if (!validatedSubcomponentCreators.contains(creatorElement = MoreTypes.asTypeElement(returnType))) {
            report.addItems((Iterable<ValidationReport.Item>)this.creatorValidator.validate(creatorElement).items());
        }
    }

    private static <T extends Element> void validateComponentDependencies(ValidationReport.Builder<T> report, Iterable<TypeMirror> types) {
        ComponentValidator.validateTypesAreDeclared(report, types, "component dependency");
        for (TypeMirror type : types) {
            if (!ModuleAnnotation.moduleAnnotation(MoreTypes.asTypeElement(type)).isPresent()) continue;
            report.addError(String.format("%s is a module, which cannot be a component dependency", type));
        }
    }

    private static <T extends Element> void validateTypesAreDeclared(final ValidationReport.Builder<T> report, Iterable<TypeMirror> types, final String typeName) {
        for (TypeMirror type : types) {
            type.accept(new SimpleTypeVisitor6<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror e, Void aVoid) {
                    report.addError(String.format("%s is not a valid %s type", e, typeName));
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType t, Void aVoid) {
                    return null;
                }
            }, null);
        }
    }

    private static Optional<AnnotationMirror> checkForAnnotations(TypeMirror type, final Set<? extends Class<? extends Annotation>> annotations) {
        return type.accept(new SimpleTypeVisitor6<Optional<AnnotationMirror>, Void>(Optional.empty()){

            @Override
            public Optional<AnnotationMirror> visitDeclared(DeclaredType t, Void p) {
                return DaggerElements.getAnyAnnotation(t.asElement(), annotations);
            }
        }, null);
    }

    private /* synthetic */ void lambda$checkConflictingEntryPoints$6(SetMultimap entryPointMethods, ExecutableElement method) {
        this.addMethodUnlessOverridden(method, entryPointMethods.get((Object)method.getSimpleName().toString()));
    }

    private /* synthetic */ void lambda$validate$2(DeclaredType subjectType, ValidationReport.Builder report, ComponentKind componentKind, ComponentAnnotation componentAnnotation, SetMultimap referencedSubcomponents, Set validatedSubcomponentCreators, ExecutableElement method) {
        ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(subjectType, method));
        List<? extends TypeMirror> parameterTypes = resolvedMethod.getParameterTypes();
        List<? extends VariableElement> parameters = method.getParameters();
        TypeMirror returnType = resolvedMethod.getReturnType();
        if (!resolvedMethod.getTypeVariables().isEmpty()) {
            report.addError("Component methods cannot have type variables", method);
        }
        Optional<AnnotationMirror> subcomponentAnnotation = ComponentValidator.checkForAnnotations(returnType, (Set)componentKind.legalSubcomponentKinds().stream().map(ComponentKind::annotation).collect(DaggerStreams.toImmutableSet()));
        Optional<AnnotationMirror> subcomponentCreatorAnnotation = ComponentValidator.checkForAnnotations(returnType, componentAnnotation.isProduction() ? Sets.intersection(ComponentCreatorAnnotation.subcomponentCreatorAnnotations(), ComponentCreatorAnnotation.productionCreatorAnnotations()) : ComponentCreatorAnnotation.subcomponentCreatorAnnotations());
        if (subcomponentAnnotation.isPresent()) {
            referencedSubcomponents.put((Object)MoreTypes.asElement(returnType), (Object)method);
            this.validateSubcomponentMethod(report, ComponentKind.forAnnotatedElement(MoreTypes.asTypeElement(returnType)).get(), method, parameters, parameterTypes, returnType, subcomponentAnnotation);
        } else if (subcomponentCreatorAnnotation.isPresent()) {
            referencedSubcomponents.put((Object)MoreTypes.asElement(returnType).getEnclosingElement(), (Object)method);
            this.validateSubcomponentCreatorMethod(report, method, parameters, returnType, validatedSubcomponentCreators);
        } else {
            switch (parameters.size()) {
                case 0: {
                    this.dependencyRequestValidator.validateDependencyRequest(report, method, returnType);
                    break;
                }
                case 1: {
                    TypeMirror parameterType = (TypeMirror)Iterables.getOnlyElement(parameterTypes);
                    report.addSubreport(this.membersInjectionValidator.validateMembersInjectionMethod(method, parameterType));
                    if (returnType.getKind().equals((Object)TypeKind.VOID) || this.types.isSameType(returnType, parameterType)) break;
                    report.addError("Members injection methods may only return the injected type or void.", method);
                    break;
                }
                default: {
                    report.addError("This method isn't a valid provision method, members injection method or subcomponent factory method. Dagger cannot implement this method", method);
                }
            }
        }
    }

    @AutoValue
    static abstract class ComponentValidationReport {
        ComponentValidationReport() {
        }

        abstract ImmutableSet<Element> referencedSubcomponents();

        abstract ValidationReport<TypeElement> report();
    }
}

