/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphConverter;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentAnnotation;
import dagger.internal.codegen.ComponentCreatorAnnotation;
import dagger.internal.codegen.ComponentCreatorValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentDescriptorFactory;
import dagger.internal.codegen.ComponentDescriptorValidator;
import dagger.internal.codegen.ComponentValidator;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.TypeCheckingProcessingStep;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ComponentProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final ComponentDescriptorValidator componentDescriptorValidator;
    private final ComponentDescriptorFactory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final SourceFileGenerator<BindingGraph> componentGenerator;
    private final BindingGraphConverter bindingGraphConverter;
    private final BindingGraphValidator bindingGraphValidator;
    private final CompilerOptions compilerOptions;
    private ImmutableSet<Element> subcomponentElements;
    private ImmutableSet<Element> subcomponentCreatorElements;
    private ImmutableMap<Element, ValidationReport<TypeElement>> creatorReportsByComponent;
    private ImmutableMap<Element, ValidationReport<TypeElement>> creatorReportsBySubcomponent;
    private ImmutableMap<Element, ValidationReport<TypeElement>> reportsBySubcomponent;

    @Inject
    ComponentProcessingStep(Messager messager, ComponentValidator componentValidator, ComponentCreatorValidator creatorValidator, ComponentDescriptorValidator componentDescriptorValidator, ComponentDescriptorFactory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, SourceFileGenerator<BindingGraph> componentGenerator, BindingGraphConverter bindingGraphConverter, BindingGraphValidator bindingGraphValidator, CompilerOptions compilerOptions) {
        super(MoreElements::asType);
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.creatorValidator = creatorValidator;
        this.componentDescriptorValidator = componentDescriptorValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.componentGenerator = componentGenerator;
        this.bindingGraphConverter = bindingGraphConverter;
        this.bindingGraphValidator = bindingGraphValidator;
        this.compilerOptions = compilerOptions;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return Sets.union(ComponentAnnotation.allComponentAnnotations(), ComponentCreatorAnnotation.allCreatorAnnotations());
    }

    @Override
    public ImmutableSet<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        this.subcomponentElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, ComponentAnnotation.subcomponentAnnotations());
        this.subcomponentCreatorElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, ComponentCreatorAnnotation.subcomponentCreatorAnnotations());
        ImmutableSet.Builder rejectedElements = ImmutableSet.builder();
        this.creatorReportsByComponent = this.processCreators((Set<? extends Element>)ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, ComponentCreatorAnnotation.rootComponentCreatorAnnotations()), (ImmutableSet.Builder<Element>)rejectedElements);
        this.creatorReportsBySubcomponent = this.processCreators((Set<? extends Element>)this.subcomponentCreatorElements, (ImmutableSet.Builder<Element>)rejectedElements);
        this.reportsBySubcomponent = this.processSubcomponents((Set<? extends Element>)this.subcomponentElements, (Set<? extends Element>)this.subcomponentCreatorElements, (ImmutableSet.Builder<Element>)rejectedElements);
        return rejectedElements.addAll(super.process(elementsByAnnotation)).build();
    }

    @Override
    protected void process(TypeElement element, ImmutableSet<Class<? extends Annotation>> annotations) {
        if (!Collections.disjoint(annotations, ComponentAnnotation.rootComponentAnnotations())) {
            this.processRootComponent(element);
        }
        if (!Collections.disjoint(annotations, ComponentAnnotation.subcomponentAnnotations())) {
            this.processSubcomponent(element);
        }
    }

    private void processRootComponent(TypeElement component) {
        if (!this.isRootComponentValid(component)) {
            return;
        }
        ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.rootComponentDescriptor(component);
        if (!this.isValid(componentDescriptor)) {
            return;
        }
        BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor, false);
        if (this.isValid(bindingGraph)) {
            this.generateComponent(bindingGraph);
        }
    }

    private void processSubcomponent(TypeElement subcomponent) {
        if (!this.compilerOptions.aheadOfTimeSubcomponents()) {
            return;
        }
        if (!this.isSubcomponentValid(subcomponent)) {
            return;
        }
        ComponentDescriptor subcomponentDescriptor = this.componentDescriptorFactory.subcomponentDescriptor(subcomponent);
        BindingGraph bindingGraph = this.bindingGraphFactory.create(subcomponentDescriptor, false);
        if (this.isValid(bindingGraph)) {
            this.generateComponent(bindingGraph);
        }
    }

    private void generateComponent(BindingGraph bindingGraph) {
        this.componentGenerator.generate(bindingGraph, this.messager);
    }

    static ImmutableSet<Element> getElementsFromAnnotations(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation, Set<Class<? extends Annotation>> annotations) {
        return ImmutableSet.copyOf((Collection)Multimaps.filterKeys(elementsByAnnotation, (Predicate)Predicates.in(annotations)).values());
    }

    private ImmutableMap<Element, ValidationReport<TypeElement>> processCreators(Set<? extends Element> builderElements, ImmutableSet.Builder<Element> rejectedElements) {
        HashMap<Element, ValidationReport<TypeElement>> reports = new HashMap<Element, ValidationReport<TypeElement>>();
        for (Element element : builderElements) {
            try {
                ValidationReport<TypeElement> report = this.creatorValidator.validate(MoreElements.asType(element));
                report.printMessagesTo(this.messager);
                reports.put(element.getEnclosingElement(), report);
            }
            catch (TypeNotPresentException e) {
                rejectedElements.add((Object)element);
            }
        }
        return ImmutableMap.copyOf(reports);
    }

    private ImmutableMap<Element, ValidationReport<TypeElement>> processSubcomponents(Set<? extends Element> subcomponentElements, Set<? extends Element> subcomponentBuilderElements, ImmutableSet.Builder<Element> rejectedElements) {
        ImmutableMap.Builder reports = ImmutableMap.builder();
        for (Element element : subcomponentElements) {
            try {
                ComponentValidator.ComponentValidationReport report = this.componentValidator.validate(MoreElements.asType(element), subcomponentElements, subcomponentBuilderElements);
                report.report().printMessagesTo(this.messager);
                reports.put((Object)element, report.report());
            }
            catch (TypeNotPresentException e) {
                rejectedElements.add((Object)element);
            }
        }
        return reports.build();
    }

    private boolean isRootComponentValid(TypeElement rootComponent) {
        ComponentValidator.ComponentValidationReport validationReport = this.componentValidator.validate(rootComponent, (Set<? extends Element>)this.subcomponentElements, (Set<? extends Element>)this.subcomponentCreatorElements);
        validationReport.report().printMessagesTo(this.messager);
        return this.isClean(validationReport);
    }

    private boolean isSubcomponentValid(Element subcomponentElement) {
        ValidationReport subcomponentCreatorReport = (ValidationReport)this.creatorReportsBySubcomponent.get((Object)subcomponentElement);
        if (subcomponentCreatorReport != null && !subcomponentCreatorReport.isClean()) {
            return false;
        }
        ValidationReport subcomponentReport = (ValidationReport)this.reportsBySubcomponent.get((Object)subcomponentElement);
        return subcomponentReport == null || subcomponentReport.isClean();
    }

    private boolean isValid(ComponentDescriptor componentDescriptor) {
        ValidationReport<TypeElement> componentDescriptorReport = this.componentDescriptorValidator.validate(componentDescriptor);
        componentDescriptorReport.printMessagesTo(this.messager);
        return componentDescriptorReport.isClean();
    }

    private boolean isValid(BindingGraph bindingGraph) {
        return this.bindingGraphValidator.isValid(this.bindingGraphConverter.convert(bindingGraph));
    }

    private boolean isClean(ComponentValidator.ComponentValidationReport report) {
        TypeElement component = report.report().subject();
        ValidationReport<TypeElement> componentReport = report.report();
        if (!componentReport.isClean()) {
            return false;
        }
        ValidationReport builderReport = (ValidationReport)this.creatorReportsByComponent.get((Object)component);
        if (builderReport != null && !builderReport.isClean()) {
            return false;
        }
        for (Element element : report.referencedSubcomponents()) {
            if (this.isSubcomponentValid(element)) continue;
            return false;
        }
        return true;
    }
}

