/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.Iterables;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.FrameworkType;
import dagger.model.DependencyRequest;
import dagger.model.RequestKind;
import java.util.Set;
import java.util.stream.Collectors;

enum FrameworkTypeMapper {
    FOR_PROVIDER{

        @Override
        public FrameworkType getFrameworkType(RequestKind requestKind) {
            switch (requestKind) {
                case INSTANCE: 
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case LAZY: {
                    return FrameworkType.PROVIDER;
                }
                case PRODUCED: 
                case PRODUCER: {
                    throw new IllegalArgumentException(requestKind.toString());
                }
            }
            throw new AssertionError(requestKind);
        }
    }
    ,
    FOR_PRODUCER{

        @Override
        public FrameworkType getFrameworkType(RequestKind requestKind) {
            switch (requestKind) {
                case INSTANCE: 
                case PRODUCED: 
                case PRODUCER: {
                    return FrameworkType.PRODUCER_NODE;
                }
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case LAZY: {
                    return FrameworkType.PROVIDER;
                }
            }
            throw new AssertionError(requestKind);
        }
    };


    static FrameworkTypeMapper forBindingType(BindingType bindingType) {
        return bindingType.equals((Object)BindingType.PRODUCTION) ? FOR_PRODUCER : FOR_PROVIDER;
    }

    abstract FrameworkType getFrameworkType(RequestKind var1);

    FrameworkType getFrameworkType(Set<DependencyRequest> requests) {
        Set frameworkTypes = requests.stream().map(request -> this.getFrameworkType(request.kind())).collect(Collectors.toSet());
        return frameworkTypes.size() == 1 ? (FrameworkType)((Object)Iterables.getOnlyElement(frameworkTypes)) : FrameworkType.PROVIDER;
    }
}

