/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentCreatorImplementation;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementExpression;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.MemberSelect;
import dagger.internal.codegen.ModuleProxies;
import dagger.internal.codegen.Optionals;
import dagger.internal.codegen.ParentComponent;
import dagger.internal.codegen.PerComponentImplementation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@PerComponentImplementation
final class ComponentRequirementExpressions {
    private final Optional<ComponentRequirementExpressions> parent;
    private final Map<ComponentRequirement, ComponentRequirementExpression> componentRequirementExpressions = new HashMap<ComponentRequirement, ComponentRequirementExpression>();
    private final BindingGraph graph;
    private final ComponentImplementation componentImplementation;
    private final CompilerOptions compilerOptions;
    private final DaggerElements elements;

    @Inject
    ComponentRequirementExpressions(@ParentComponent Optional<ComponentRequirementExpressions> parent, BindingGraph graph, ComponentImplementation componentImplementation, CompilerOptions compilerOptions, DaggerElements elements) {
        this.parent = parent;
        this.graph = graph;
        this.componentImplementation = componentImplementation;
        this.compilerOptions = compilerOptions;
        this.elements = elements;
    }

    CodeBlock getExpression(ComponentRequirement componentRequirement, ClassName requestingClass) {
        return this.getExpression(componentRequirement).getExpression(requestingClass);
    }

    CodeBlock getExpressionDuringInitialization(ComponentRequirement componentRequirement, ClassName requestingClass) {
        return this.getExpression(componentRequirement).getExpressionDuringInitialization(requestingClass);
    }

    ComponentRequirementExpression getExpression(ComponentRequirement componentRequirement) {
        if (this.graph.componentRequirements().contains((Object)componentRequirement)) {
            return this.componentRequirementExpressions.computeIfAbsent(componentRequirement, this::createMethodOrField);
        }
        if (this.parent.isPresent()) {
            return this.parent.get().getExpression(componentRequirement);
        }
        if (componentRequirement.kind().isModule() && this.compilerOptions.aheadOfTimeSubcomponents()) {
            return new PrunedModifiableModule(componentRequirement);
        }
        throw new IllegalStateException("no component requirement expression found for " + componentRequirement);
    }

    private ComponentRequirementExpression createMethodOrField(ComponentRequirement requirement) {
        if (this.componentImplementation.isAbstract() && requirement.kind().isModule()) {
            return new ModifiableModule(requirement);
        }
        return this.createField(requirement);
    }

    private ComponentRequirementExpression createField(ComponentRequirement requirement) {
        Optional<ComponentCreatorImplementation> creatorImplementation = Optionals.firstPresent(this.componentImplementation.baseImplementation().flatMap(c -> c.creatorImplementation()), this.componentImplementation.creatorImplementation(), new Optional[0]);
        if (creatorImplementation.isPresent()) {
            return new ComponentParameterField(requirement, this.componentImplementation, Optional.empty());
        }
        if (this.graph.factoryMethod().isPresent() && this.graph.factoryMethodParameters().containsKey((Object)requirement)) {
            String parameterName = ((VariableElement)this.graph.factoryMethodParameters().get((Object)requirement)).getSimpleName().toString();
            return new ComponentParameterField(requirement, this.componentImplementation, Optional.of(parameterName));
        }
        if (requirement.kind().isModule()) {
            return new InstantiableModuleField(requirement, this.componentImplementation);
        }
        throw new AssertionError((Object)String.format("Can't create %s in %s", requirement, this.componentImplementation.name()));
    }

    private static final class PrunedModifiableModule
    implements ComponentRequirementExpression {
        private final ComponentRequirement module;

        private PrunedModifiableModule(ComponentRequirement module) {
            Preconditions.checkArgument((boolean)module.kind().isModule());
            this.module = module;
        }

        @Override
        public CodeBlock getExpression(ClassName requestingClass) {
            throw new UnsupportedOperationException(this.module + " is pruned - it cannot be requested");
        }

        @Override
        public CodeBlock getModifiableModuleMethodExpression(ClassName requestingClass) {
            return CodeBlock.of((String)"throw new UnsupportedOperationException($T.class + $S)", (Object[])new Object[]{this.module.typeElement(), " has been pruned from the final resolved binding graph. If this exception is thrown, it is a Dagger bug, so please report it!"});
        }
    }

    private final class ModifiableModule
    implements ComponentRequirementExpression {
        private final ComponentRequirement module;
        private final Supplier<MemberSelect> method = Suppliers.memoize(this::methodSelect);

        private ModifiableModule(ComponentRequirement module) {
            Preconditions.checkArgument((boolean)module.kind().isModule());
            this.module = module;
        }

        @Override
        public CodeBlock getExpression(ClassName requestingClass) {
            return ((MemberSelect)this.method.get()).getExpressionFor(requestingClass);
        }

        private MemberSelect methodSelect() {
            String methodName = ComponentRequirementExpressions.this.componentImplementation.supertypeModifiableModuleMethodName(this.module).orElseGet(this::createMethod);
            return MemberSelect.localMethod(ComponentRequirementExpressions.this.componentImplementation.name(), methodName);
        }

        private String createMethod() {
            String methodName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, ComponentRequirementExpressions.this.componentImplementation.getUniqueMethodName(this.module.typeElement().getSimpleName().toString()));
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.get((TypeMirror)this.module.type()));
            if (ComponentRequirementExpressions.this.graph.componentDescriptor().creatorDescriptor().isPresent()) {
                methodBuilder.addStatement("return $L", new Object[]{ComponentRequirementExpressions.this.createField(this.module).getExpression(ComponentRequirementExpressions.this.componentImplementation.name())});
            } else {
                methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
            }
            ComponentRequirementExpressions.this.componentImplementation.addModifiableModuleMethod(this.module, methodBuilder.build());
            return methodName;
        }
    }

    private static final class ComponentParameterField
    extends AbstractField {
        private final String parameterName;

        private ComponentParameterField(ComponentRequirement componentRequirement, ComponentImplementation componentImplementation, Optional<String> name) {
            super(componentRequirement, componentImplementation);
            componentImplementation.addComponentRequirementParameter(componentRequirement);
            String baseName = name.filter(n -> !n.equals(this.fieldName)).orElse(this.fieldName + "Param");
            this.parameterName = componentImplementation.getParameterName(componentRequirement, baseName);
        }

        @Override
        public CodeBlock getExpressionDuringInitialization(ClassName requestingClass) {
            if (this.componentImplementation.name().equals((Object)requestingClass)) {
                return CodeBlock.of((String)"$L", (Object[])new Object[]{this.parameterName});
            }
            return this.getExpression(requestingClass);
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = $L;", (Object[])new Object[]{componentField, this.parameterName});
        }
    }

    private final class InstantiableModuleField
    extends AbstractField {
        private final TypeElement moduleElement;

        private InstantiableModuleField(ComponentRequirement module, ComponentImplementation componentImplementation) {
            super(module, componentImplementation);
            Preconditions.checkArgument((boolean)module.kind().isModule());
            this.moduleElement = module.typeElement();
        }

        @Override
        CodeBlock fieldInitialization(FieldSpec componentField) {
            return CodeBlock.of((String)"this.$N = $L;", (Object[])new Object[]{componentField, ModuleProxies.newModuleInstance(this.moduleElement, this.componentImplementation.name(), ComponentRequirementExpressions.this.elements)});
        }
    }

    private static abstract class AbstractField
    implements ComponentRequirementExpression {
        final ComponentRequirement componentRequirement;
        final ComponentImplementation componentImplementation;
        final String fieldName;
        private final Supplier<MemberSelect> field = Suppliers.memoize(this::addField);

        private AbstractField(ComponentRequirement componentRequirement, ComponentImplementation componentImplementation) {
            this.componentRequirement = (ComponentRequirement)Preconditions.checkNotNull((Object)componentRequirement);
            this.componentImplementation = (ComponentImplementation)Preconditions.checkNotNull((Object)componentImplementation);
            this.fieldName = componentImplementation.getUniqueFieldName(componentRequirement.variableName());
        }

        @Override
        public CodeBlock getExpression(ClassName requestingClass) {
            return ((MemberSelect)this.field.get()).getExpressionFor(requestingClass);
        }

        private MemberSelect addField() {
            FieldSpec field = this.createField();
            this.componentImplementation.addField(ComponentImplementation.FieldSpecKind.COMPONENT_REQUIREMENT_FIELD, field);
            this.componentImplementation.addComponentRequirementInitialization(this.fieldInitialization(field));
            return MemberSelect.localField(this.componentImplementation.name(), this.fieldName);
        }

        private FieldSpec createField() {
            FieldSpec.Builder field = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)this.componentRequirement.type()), (String)this.fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE});
            if (!this.componentImplementation.isAbstract()) {
                field.addModifiers(new Modifier[]{Modifier.FINAL});
            }
            return field.build();
        }

        abstract CodeBlock fieldInitialization(FieldSpec var1);
    }
}

