/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.BindsInstance;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentKind;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentValidator;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.TypeCheckingProcessingStep;
import dagger.internal.codegen.TypeSpecs;
import dagger.producers.internal.CancellationListener;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

final class ComponentHjarProcessingStep
extends TypeCheckingProcessingStep<TypeElement> {
    private final SourceVersion sourceVersion;
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final Filer filer;
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;

    @Inject
    ComponentHjarProcessingStep(SourceVersion sourceVersion, DaggerElements elements, DaggerTypes types, Filer filer, Messager messager, ComponentValidator componentValidator, ComponentDescriptor.Factory componentDescriptorFactory) {
        super(MoreElements::asType);
        this.sourceVersion = sourceVersion;
        this.elements = elements;
        this.types = types;
        this.filer = filer;
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ComponentKind.annotationsFor(ComponentKind.rootComponentKinds());
    }

    @Override
    protected void process(TypeElement componentTypeElement, ImmutableSet<Class<? extends Annotation>> annotations) {
        ComponentValidator.ComponentValidationReport validationReport = this.componentValidator.validate(componentTypeElement, (Set<? extends Element>)ImmutableSet.of(), (Set<? extends Element>)ImmutableSet.of());
        validationReport.report().printMessagesTo(this.messager);
        if (validationReport.report().isClean()) {
            new EmptyComponentGenerator(this.filer, this.elements, this.sourceVersion).generate(this.componentDescriptorFactory.forTypeElement(componentTypeElement), this.messager);
        }
    }

    private MethodSpec emptyComponentMethod(TypeElement typeElement, ExecutableElement baseMethod) {
        return MethodSpec.overriding((ExecutableElement)baseMethod, (DeclaredType)MoreTypes.asDeclared(typeElement.asType()), (Types)this.types).build();
    }

    private MethodSpec privateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private Stream<ComponentRequirement> componentRequirements(ComponentDescriptor component) {
        Preconditions.checkArgument((boolean)component.kind().isRoot());
        return Stream.concat(component.dependencies().stream(), component.modules().stream().filter(module -> !module.moduleElement().getModifiers().contains((Object)Modifier.ABSTRACT)).map(module -> ComponentRequirement.forModule(module.moduleElement().asType())));
    }

    private boolean hasBindsInstanceMethods(ComponentDescriptor componentDescriptor) {
        return componentDescriptor.creatorDescriptor().isPresent() && ElementFilter.methodsIn(this.elements.getAllMembers(componentDescriptor.creatorDescriptor().get().typeElement())).stream().anyMatch(method -> MoreElements.isAnnotationPresent(method, BindsInstance.class));
    }

    private MethodSpec builderInstanceMethod(TypeElement componentRequirement, ClassName builderClass) {
        String simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, componentRequirement.getSimpleName().toString());
        return MethodSpec.methodBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((TypeElement)componentRequirement), simpleName, new Modifier[0]).returns((TypeName)builderClass).build();
    }

    private MethodSpec builderBuildMethod(ComponentDescriptor component) {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((TypeElement)component.typeElement())).build();
    }

    private MethodSpec staticBuilderMethod(TypeName builderMethodReturnType) {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(builderMethodReturnType).build();
    }

    private MethodSpec createMethod(ComponentDescriptor componentDescriptor) {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get((TypeElement)componentDescriptor.typeElement())).build();
    }

    private MethodSpec onProducerFutureCancelledMethod() {
        return MethodSpec.methodBuilder((String)"onProducerFutureCancelled").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.BOOLEAN, "mayInterruptIfRunning", new Modifier[0]).build();
    }

    private final class EmptyComponentGenerator
    extends SourceFileGenerator<ComponentDescriptor> {
        EmptyComponentGenerator(Filer filer, DaggerElements elements, SourceVersion sourceVersion) {
            super(filer, elements, sourceVersion);
        }

        @Override
        ClassName nameGeneratedType(ComponentDescriptor input) {
            return ComponentGenerator.componentName(input.typeElement());
        }

        @Override
        Element originatingElement(ComponentDescriptor input) {
            return input.typeElement();
        }

        @Override
        Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ComponentDescriptor componentDescriptor) {
            ClassName builderMethodReturnType;
            TypeSpec.Builder generatedComponent = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(ComponentHjarProcessingStep.this.privateConstructor());
            TypeElement componentElement = componentDescriptor.typeElement();
            TypeSpecs.addSupertype(generatedComponent, componentElement);
            if (componentDescriptor.creatorDescriptor().isPresent()) {
                builderMethodReturnType = ClassName.get((TypeElement)componentDescriptor.creatorDescriptor().get().typeElement());
            } else {
                ClassName builderClassName;
                TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addMethod(ComponentHjarProcessingStep.this.privateConstructor());
                builderMethodReturnType = builderClassName = generatedTypeName.nestedClass("Builder");
                ComponentHjarProcessingStep.this.componentRequirements(componentDescriptor).map(requirement -> ComponentHjarProcessingStep.this.builderInstanceMethod(requirement.typeElement(), builderClassName)).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
                builder.addMethod(ComponentHjarProcessingStep.this.builderBuildMethod(componentDescriptor));
                generatedComponent.addType(builder.build());
            }
            generatedComponent.addMethod(ComponentHjarProcessingStep.this.staticBuilderMethod((TypeName)builderMethodReturnType));
            if (ComponentHjarProcessingStep.this.componentRequirements(componentDescriptor).noneMatch(requirement -> requirement.requiresAPassedInstance(ComponentHjarProcessingStep.this.elements, ComponentHjarProcessingStep.this.types)) && !ComponentHjarProcessingStep.this.hasBindsInstanceMethods(componentDescriptor)) {
                generatedComponent.addMethod(ComponentHjarProcessingStep.this.createMethod(componentDescriptor));
            }
            DeclaredType componentType = MoreTypes.asDeclared(componentElement.asType());
            HashSet methodSignatures = Sets.newHashSetWithExpectedSize((int)componentDescriptor.componentMethods().size());
            componentDescriptor.componentMethods().stream().filter(method -> methodSignatures.add(MethodSignature.forComponentMethod(method, componentType, ComponentHjarProcessingStep.this.types))).forEach(method -> generatedComponent.addMethod(ComponentHjarProcessingStep.this.emptyComponentMethod(componentElement, method.methodElement())));
            if (componentDescriptor.kind().isProducer()) {
                generatedComponent.addSuperinterface((TypeName)ClassName.get(CancellationListener.class)).addMethod(ComponentHjarProcessingStep.this.onProducerFutureCancelledMethod());
            }
            return Optional.of(generatedComponent);
        }
    }
}

