/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingRequest;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.ModifiableBindingMethods;
import dagger.internal.codegen.ModifiableBindingType;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

abstract class ModifiableAbstractMethodBindingExpression
extends BindingExpression {
    private final ComponentImplementation componentImplementation;
    private final ModifiableBindingType modifiableBindingType;
    private final BindingRequest request;
    private final Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod;
    private final DaggerTypes types;
    private Optional<String> methodName;

    ModifiableAbstractMethodBindingExpression(ComponentImplementation componentImplementation, ModifiableBindingType modifiableBindingType, BindingRequest request, Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod, Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod, DaggerTypes types) {
        this.componentImplementation = componentImplementation;
        this.modifiableBindingType = modifiableBindingType;
        this.request = request;
        this.matchingComponentMethod = matchingComponentMethod;
        this.types = types;
        this.methodName = ModifiableAbstractMethodBindingExpression.initializeMethodName(matchingComponentMethod, matchingModifiableBindingMethod);
    }

    private static Optional<String> initializeMethodName(Optional<ComponentDescriptor.ComponentMethodDescriptor> matchingComponentMethod, Optional<ModifiableBindingMethods.ModifiableBindingMethod> matchingModifiableBindingMethod) {
        if (matchingComponentMethod.isPresent()) {
            return Optional.of(matchingComponentMethod.get().methodElement().getSimpleName().toString());
        }
        if (matchingModifiableBindingMethod.isPresent()) {
            return Optional.of(matchingModifiableBindingMethod.get().methodSpec().name);
        }
        return Optional.empty();
    }

    @Override
    final Expression getDependencyExpression(ClassName requestingClass) {
        this.addUnimplementedMethod();
        return Expression.create(this.returnType(), this.componentImplementation.name().equals((Object)requestingClass) ? CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodName.get()}) : CodeBlock.of((String)"$T.this.$N()", (Object[])new Object[]{this.componentImplementation.name(), this.methodName.get()}));
    }

    private void addUnimplementedMethod() {
        if (!this.methodName.isPresent()) {
            this.methodName = Optional.of(this.chooseMethodName());
            TypeMirror returnType = this.returnType();
            this.componentImplementation.addModifiableBindingMethod(this.modifiableBindingType, this.request, returnType, MethodSpec.methodBuilder((String)this.methodName.get()).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.ABSTRACT}).returns(TypeName.get((TypeMirror)returnType)).build(), false);
        }
    }

    private TypeMirror returnType() {
        if (this.matchingComponentMethod.isPresent()) {
            return this.matchingComponentMethod.get().resolvedReturnType(this.types);
        }
        TypeMirror requestedType = this.request.requestedType(this.contributedType(), this.types);
        return this.types.publiclyAccessibleType(requestedType);
    }

    protected abstract TypeMirror contributedType();

    abstract String chooseMethodName();
}

