/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import dagger.Lazy;
import dagger.internal.DoubleCheck;
import dagger.internal.ProviderOfLazy;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.RequestKinds;
import dagger.model.RequestKind;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.internal.Producers;
import java.util.Optional;
import javax.inject.Provider;
import javax.lang.model.type.DeclaredType;

enum FrameworkType {
    PROVIDER{

        @Override
        Class<?> frameworkClass() {
            return Provider.class;
        }

        @Override
        Optional<RequestKind> requestKind() {
            return Optional.of(RequestKind.PROVIDER);
        }

        @Override
        CodeBlock to(RequestKind requestKind, CodeBlock from) {
            switch (requestKind) {
                case INSTANCE: {
                    return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{from});
                }
                case LAZY: {
                    return CodeBlock.of((String)"$T.lazy($L)", (Object[])new Object[]{DoubleCheck.class, from});
                }
                case PROVIDER: {
                    return from;
                }
                case PROVIDER_OF_LAZY: {
                    return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{ProviderOfLazy.class, from});
                }
                case PRODUCER: {
                    return CodeBlock.of((String)"$T.producerFromProvider($L)", (Object[])new Object[]{Producers.class, from});
                }
                case FUTURE: {
                    return CodeBlock.of((String)"$T.immediateFuture($L)", (Object[])new Object[]{Futures.class, this.to(RequestKind.INSTANCE, from)});
                }
                case PRODUCED: {
                    return CodeBlock.of((String)"$T.successful($L)", (Object[])new Object[]{Produced.class, this.to(RequestKind.INSTANCE, from)});
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }

        @Override
        Expression to(RequestKind requestKind, Expression from, DaggerTypes types) {
            CodeBlock codeBlock = this.to(requestKind, from.codeBlock());
            switch (requestKind) {
                case INSTANCE: {
                    return Expression.create(types.unwrapTypeOrObject(from.type()), codeBlock);
                }
                case PROVIDER: {
                    return from;
                }
                case PROVIDER_OF_LAZY: {
                    DeclaredType lazyType = types.rewrapType(from.type(), Lazy.class);
                    return Expression.create(types.wrapType(lazyType, Provider.class), codeBlock);
                }
                case FUTURE: {
                    return Expression.create(types.rewrapType(from.type(), ListenableFuture.class), codeBlock);
                }
            }
            return Expression.create(types.rewrapType(from.type(), RequestKinds.frameworkClass(requestKind)), codeBlock);
        }
    }
    ,
    PRODUCER_NODE{

        @Override
        Class<?> frameworkClass() {
            return Producer.class;
        }

        @Override
        Optional<RequestKind> requestKind() {
            return Optional.empty();
        }

        @Override
        CodeBlock to(RequestKind requestKind, CodeBlock from) {
            switch (requestKind) {
                case FUTURE: {
                    return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{from});
                }
                case PRODUCER: {
                    return from;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }

        @Override
        Expression to(RequestKind requestKind, Expression from, DaggerTypes types) {
            switch (requestKind) {
                case FUTURE: {
                    return Expression.create(types.rewrapType(from.type(), ListenableFuture.class), this.to(requestKind, from.codeBlock()));
                }
                case PRODUCER: {
                    return Expression.create(from.type(), this.to(requestKind, from.codeBlock()));
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }
    };


    static FrameworkType forBindingType(BindingType bindingType) {
        switch (bindingType) {
            case PROVISION: {
                return PROVIDER;
            }
            case PRODUCTION: {
                return PRODUCER_NODE;
            }
        }
        throw new AssertionError((Object)bindingType);
    }

    static Optional<FrameworkType> forRequestKind(RequestKind requestKind) {
        switch (requestKind) {
            case PROVIDER: {
                return Optional.of(PROVIDER);
            }
        }
        return Optional.empty();
    }

    abstract Class<?> frameworkClass();

    ParameterizedTypeName frameworkClassOf(TypeName valueType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(this.frameworkClass()), (TypeName[])new TypeName[]{valueType});
    }

    abstract Optional<RequestKind> requestKind();

    abstract CodeBlock to(RequestKind var1, CodeBlock var2);

    abstract Expression to(RequestKind var1, Expression var2, DaggerTypes var3);

    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, super.toString());
    }
}

