/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.ValidationReport;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class ComponentHierarchyValidator {
    private final CompilerOptions compilerOptions;

    @Inject
    ComponentHierarchyValidator(CompilerOptions compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    ValidationReport<TypeElement> validate(ComponentDescriptor componentDescriptor) {
        ValidationReport.Builder<TypeElement> report = ValidationReport.about(componentDescriptor.typeElement());
        this.validateSubcomponentMethods(report, componentDescriptor, (ImmutableMap<TypeElement, TypeElement>)Maps.toMap(componentDescriptor.moduleTypes(), (Function)Functions.constant((Object)componentDescriptor.typeElement())));
        if (this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
            this.validateScopeHierarchy(report, componentDescriptor, (SetMultimap<ComponentDescriptor, Scope>)LinkedHashMultimap.create());
        }
        return report.build();
    }

    private void validateSubcomponentMethods(ValidationReport.Builder<?> report, ComponentDescriptor componentDescriptor, ImmutableMap<TypeElement, TypeElement> existingModuleToOwners) {
        componentDescriptor.childComponentsDeclaredByFactoryMethods().forEach((method, childComponent) -> {
            if (childComponent.hasCreator()) {
                report.addError("Components may not have factory methods for subcomponents that define a builder.", method.methodElement());
            } else {
                this.validateFactoryMethodParameters(report, (ComponentDescriptor.ComponentMethodDescriptor)method, existingModuleToOwners);
            }
            this.validateSubcomponentMethods(report, (ComponentDescriptor)childComponent, (ImmutableMap<TypeElement, TypeElement>)new ImmutableMap.Builder().putAll((Map)existingModuleToOwners).putAll((Map)Maps.toMap((Iterable)Sets.difference(childComponent.moduleTypes(), (Set)existingModuleToOwners.keySet()), (Function)Functions.constant((Object)childComponent.typeElement()))).build());
        });
    }

    private void validateFactoryMethodParameters(ValidationReport.Builder<?> report, ComponentDescriptor.ComponentMethodDescriptor subcomponentMethodDescriptor, ImmutableMap<TypeElement, TypeElement> existingModuleToOwners) {
        for (VariableElement variableElement : subcomponentMethodDescriptor.methodElement().getParameters()) {
            TypeElement moduleType = MoreTypes.asTypeElement(variableElement.asType());
            TypeElement originatingComponent = (TypeElement)existingModuleToOwners.get((Object)moduleType);
            if (originatingComponent == null) continue;
            report.addError(String.format("%s is present in %s. A subcomponent cannot use an instance of a module that differs from its parent.", moduleType.getSimpleName(), originatingComponent.getQualifiedName()), variableElement);
        }
    }

    private void validateScopeHierarchy(ValidationReport.Builder<TypeElement> report, ComponentDescriptor subject, SetMultimap<ComponentDescriptor, Scope> scopesByComponent) {
        scopesByComponent.putAll((Object)subject, subject.scopes());
        for (ComponentDescriptor childComponent : subject.childComponents()) {
            this.validateScopeHierarchy(report, childComponent, scopesByComponent);
        }
        scopesByComponent.removeAll((Object)subject);
        Predicate subjectScopes = subject.kind().isProducer() ? Predicates.and((Predicate)Predicates.in(subject.scopes()), (Predicate)Predicates.not(Scope::isProductionScope)) : Predicates.in(subject.scopes());
        SetMultimap overlappingScopes = Multimaps.filterValues(scopesByComponent, (Predicate)subjectScopes);
        if (!overlappingScopes.isEmpty()) {
            StringBuilder error = new StringBuilder().append(subject.typeElement().getQualifiedName()).append(" has conflicting scopes:");
            for (Map.Entry entry : overlappingScopes.entries()) {
                Scope scope = (Scope)entry.getValue();
                error.append("\n  ").append(((ComponentDescriptor)entry.getKey()).typeElement().getQualifiedName()).append(" also has ").append(Scopes.getReadableSource(scope));
            }
            report.addItem(error.toString(), this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), subject.typeElement());
        }
    }
}

