/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Verify;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentImplementation;
import dagger.internal.codegen.ComponentImplementationFactory;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ComponentGenerator
extends SourceFileGenerator<BindingGraph> {
    private final ComponentImplementationFactory componentImplementationFactory;

    @Inject
    ComponentGenerator(Filer filer, DaggerElements elements, SourceVersion sourceVersion, ComponentImplementationFactory componentImplementationFactory) {
        super(filer, elements, sourceVersion);
        this.componentImplementationFactory = componentImplementationFactory;
    }

    @Override
    ClassName nameGeneratedType(BindingGraph input) {
        return ComponentGenerator.componentName(input.componentTypeElement());
    }

    static ClassName componentName(TypeElement componentDefinitionType) {
        ClassName componentName = ClassName.get((TypeElement)componentDefinitionType);
        return ClassName.get((String)componentName.packageName(), (String)("Dagger" + SourceFiles.classFileName(componentName)), (String[])new String[0]);
    }

    @Override
    Element originatingElement(BindingGraph input) {
        return input.componentTypeElement();
    }

    @Override
    Optional<TypeSpec.Builder> write(ClassName componentName, BindingGraph bindingGraph) {
        ComponentImplementation componentImplementation = this.componentImplementationFactory.createComponentImplementation(bindingGraph);
        Verify.verify((boolean)componentImplementation.name().equals((Object)componentName));
        return Optional.of(componentImplementation.generate());
    }
}

