/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.BindsInstance;
import dagger.internal.codegen.ComponentKind;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.ModuleKind;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.TypeCheckingProcessingStep;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class BindsInstanceProcessingStep
extends TypeCheckingProcessingStep<ExecutableElement> {
    private static final ImmutableSet<Class<? extends Annotation>> COMPONENT_ANNOTATIONS = Arrays.stream(ComponentKind.values()).filter(kind -> !kind.isForModuleValidation()).map(ComponentKind::annotation).collect(DaggerStreams.toImmutableSet());
    private static final ImmutableSet<Class<? extends Annotation>> MODULE_ANNOTATIONS = Arrays.stream(ModuleKind.values()).map(ModuleKind::annotation).collect(DaggerStreams.toImmutableSet());
    private final Messager messager;

    @Inject
    BindsInstanceProcessingStep(Messager messager) {
        super(MoreElements::asExecutable);
        this.messager = messager;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(BindsInstance.class);
    }

    @Override
    protected void process(ExecutableElement method, ImmutableSet<Class<? extends Annotation>> annotations) {
        ValidationReport.Builder<ExecutableElement> report = ValidationReport.about(method);
        if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            report.addError("@BindsInstance methods must be abstract");
        }
        if (method.getParameters().size() != 1) {
            report.addError("@BindsInstance methods should have exactly one parameter for the bound type");
        } else {
            VariableElement parameter = (VariableElement)Iterables.getOnlyElement(method.getParameters());
            if (FrameworkTypes.isFrameworkType(parameter.asType())) {
                report.addError("@BindsInstance parameters may not be framework types", parameter);
            }
        }
        TypeElement enclosingType = MoreElements.asType(method.getEnclosingElement());
        if (DaggerElements.isAnyAnnotationPresent(enclosingType, MODULE_ANNOTATIONS)) {
            report.addError(String.format("@BindsInstance methods should not be included in @%ss. Did you mean @Binds?", MoreAnnotationMirrors.simpleName(ConfigurationAnnotations.getModuleAnnotation(enclosingType).get())));
        }
        if (DaggerElements.isAnyAnnotationPresent(enclosingType, COMPONENT_ANNOTATIONS)) {
            AnnotationMirror componentAnnotation = ConfigurationAnnotations.getComponentOrSubcomponentAnnotation(enclosingType).get();
            report.addError(String.format("@BindsInstance methods should not be included in @%1$ss. Did you mean to put it in a @%1$s.Builder?", MoreAnnotationMirrors.simpleName(componentAnnotation)));
        }
        report.build().printMessagesTo(this.messager);
    }
}

