/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.ProcessingOptions;
import dagger.spi.BindingGraphPlugin;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.inject.Singleton;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Module
interface BindingGraphPluginsModule {
    @Provides
    @Singleton
    public static ImmutableList<BindingGraphPlugin> bindingGraphPlugins(Filer filer, Types types, Elements elements, @ProcessingOptions Map<String, String> processingOptions) {
        ClassLoader classLoader = BindingGraphPluginsModule.class.getClassLoader();
        ImmutableList bindingGraphPlugins = ImmutableList.copyOf(ServiceLoader.load(BindingGraphPlugin.class, classLoader));
        for (BindingGraphPlugin plugin : bindingGraphPlugins) {
            plugin.initFiler(filer);
            plugin.initTypes(types);
            plugin.initElements(elements);
            Set supportedOptions = plugin.supportedOptions();
            if (supportedOptions.isEmpty()) continue;
            plugin.initOptions(Maps.filterKeys(processingOptions, supportedOptions::contains));
        }
        return bindingGraphPlugins;
    }
}

