/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.MemoizedSentinel;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingVariableNamer;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ReferenceReleasingManagerFields;
import dagger.internal.codegen.RequestKinds;
import dagger.model.RequestKind;
import dagger.model.Scope;
import dagger.shaded.auto.common.MoreTypes;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class PrivateMethodBindingExpression
extends BindingExpression {
    private final GeneratedComponentModel generatedComponentModel;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final BindingExpression delegate;
    private final Map<RequestKind, String> methodNames = new EnumMap<RequestKind, String>(RequestKind.class);
    private final Map<RequestKind, String> fieldNames = new EnumMap<RequestKind, String>(RequestKind.class);
    private final ContributionBinding binding;
    private final CompilerOptions compilerOptions;
    private final ReferenceReleasingManagerFields referenceReleasingManagerFields;
    private final DaggerTypes types;
    private final Elements elements;

    PrivateMethodBindingExpression(GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions componentBindingExpressions, BindingExpression delegate, ReferenceReleasingManagerFields referenceReleasingManagerFields, CompilerOptions compilerOptions, DaggerTypes types, Elements elements) {
        super(delegate.resolvedBindings(), delegate.requestKind());
        this.generatedComponentModel = generatedComponentModel;
        this.componentBindingExpressions = componentBindingExpressions;
        this.delegate = delegate;
        this.binding = this.resolvedBindings().contributionBinding();
        this.referenceReleasingManagerFields = referenceReleasingManagerFields;
        this.compilerOptions = compilerOptions;
        this.types = types;
        this.elements = elements;
    }

    @Override
    protected CodeBlock doGetComponentMethodImplementation(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ClassName requestingClass) {
        if (!this.canInlineScope() && this.ignorePrivateMethodStrategy()) {
            return this.delegate.getComponentMethodImplementation(componentMethod, requestingClass);
        }
        return this.findComponentMethod().map(method -> method.equals(componentMethod)).orElse(false) != false ? this.methodBody() : super.doGetComponentMethodImplementation(componentMethod, requestingClass);
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        if (!this.canInlineScope() && (this.ignorePrivateMethodStrategy() || this.isNullaryProvisionMethod())) {
            return this.delegate.getDependencyExpression(requestingClass);
        }
        if (!this.methodNames.containsKey(this.requestKind())) {
            Optional<ComponentDescriptor.ComponentMethodDescriptor> componentMethod = this.findComponentMethod();
            String name = componentMethod.isPresent() ? componentMethod.get().methodElement().getSimpleName().toString() : this.generatedComponentModel.getUniqueMethodName(this.methodName());
            this.methodNames.put(this.requestKind(), name);
            if (!componentMethod.isPresent()) {
                this.createMethod(name);
            }
        }
        CodeBlock invocation = this.componentName().equals((Object)requestingClass) ? CodeBlock.of((String)"$N()", (Object[])new Object[]{this.methodNames.get(this.requestKind())}) : CodeBlock.of((String)"$T.this.$N()", (Object[])new Object[]{this.componentName(), this.methodNames.get(this.requestKind())});
        return Expression.create(this.returnType(), invocation);
    }

    private ClassName componentName() {
        return this.generatedComponentModel.name();
    }

    private boolean ignorePrivateMethodStrategy() {
        switch (this.requestKind()) {
            case INSTANCE: 
            case FUTURE: {
                return false;
            }
            case PROVIDER: 
            case LAZY: 
            case PROVIDER_OF_LAZY: {
                return !this.compilerOptions.experimentalAndroidMode() || this.binding.scope().isPresent() && !this.canInlineScope() || this.binding.factoryCreationStrategy().equals((Object)ContributionBinding.FactoryCreationStrategy.SINGLETON_INSTANCE);
            }
        }
        return !this.compilerOptions.experimentalAndroidMode();
    }

    private boolean isNullaryProvisionMethod() {
        return (this.requestKind().equals((Object)RequestKind.INSTANCE) || this.requestKind().equals((Object)RequestKind.FUTURE)) && this.binding.dependencies().isEmpty() && !this.findComponentMethod().isPresent();
    }

    private boolean canInlineScope() {
        return this.compilerOptions.experimentalAndroidMode() && this.binding.scope().isPresent() && !this.referenceReleasingManagerFields.requiresReleasableReferences(this.binding.scope().get());
    }

    private Optional<ComponentDescriptor.ComponentMethodDescriptor> findComponentMethod() {
        return this.resolvedBindings().owningComponent().componentMethods().stream().filter(method -> this.componentMethodMatchesRequestBindingKeyAndKind((ComponentDescriptor.ComponentMethodDescriptor)method)).findFirst();
    }

    private boolean componentMethodMatchesRequestBindingKeyAndKind(ComponentDescriptor.ComponentMethodDescriptor componentMethod) {
        return componentMethod.dependencyRequest().filter(request -> request.bindingKey().equals(this.bindingKey())).filter(request -> request.kind().equals((Object)this.requestKind())).isPresent();
    }

    private void createMethod(String name) {
        this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.PRIVATE_METHOD, MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PRIVATE}).returns(TypeName.get((TypeMirror)this.returnType())).addCode(this.methodBody()).build());
    }

    private TypeMirror returnType() {
        if (this.requestKind().equals((Object)RequestKind.INSTANCE) && this.binding.contributedPrimitiveType().isPresent()) {
            return this.binding.contributedPrimitiveType().get();
        }
        return this.accessibleType(RequestKinds.requestType(this.requestKind(), this.binding.contributedType(), this.types));
    }

    private CodeBlock methodBody() {
        switch (this.requestKind()) {
            case PROVIDER: {
                return CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.providerTypeSpec()});
            }
            case INSTANCE: {
                if (!this.canInlineScope()) break;
                Scope scope = this.resolvedBindings().scope().get();
                return scope.isReusable() ? this.singleCheck() : this.doubleCheck();
            }
        }
        return CodeBlock.of((String)"return $L;", (Object[])new Object[]{this.delegate.getDependencyExpression(this.componentName()).codeBlock()});
    }

    private CodeBlock singleCheck() {
        String fieldName = this.getMemoizedFieldName();
        return CodeBlock.builder().beginControlFlow("if ($N instanceof $T)", new Object[]{fieldName, MemoizedSentinel.class}).addStatement("$N = $L", new Object[]{fieldName, this.delegate.getDependencyExpression(this.componentName()).codeBlock()}).endControlFlow().addStatement("return ($T) $N", new Object[]{this.returnType(), fieldName}).build();
    }

    private CodeBlock doubleCheck() {
        String fieldName = this.getMemoizedFieldName();
        fieldName = fieldName.contentEquals("local") ? "this." + fieldName : fieldName;
        return CodeBlock.builder().addStatement("$T local = $L", new Object[]{TypeName.OBJECT, fieldName}).beginControlFlow("if (local instanceof $T)", new Object[]{MemoizedSentinel.class}).beginControlFlow("synchronized (local)", new Object[0]).beginControlFlow("if (local == $L)", new Object[]{fieldName}).addStatement("$L = $L", new Object[]{fieldName, this.delegate.getDependencyExpression(this.componentName()).codeBlock()}).endControlFlow().addStatement("local = $L", new Object[]{fieldName}).endControlFlow().endControlFlow().addStatement("return ($T) local", new Object[]{this.returnType()}).build();
    }

    private String getMemoizedFieldName() {
        if (!this.fieldNames.containsKey(this.requestKind())) {
            String name = this.generatedComponentModel.getUniqueFieldName(BindingVariableNamer.name(this.binding));
            this.generatedComponentModel.addField(GeneratedComponentModel.FieldSpecKind.PRIVATE_METHOD_SCOPED_FIELD, FieldSpec.builder((TypeName)TypeName.OBJECT, (String)name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).initializer("new $T()", new Object[]{MemoizedSentinel.class}).build());
            this.fieldNames.put(this.requestKind(), name);
        }
        return this.fieldNames.get(this.requestKind());
    }

    private TypeSpec providerTypeSpec() {
        return TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface(TypeName.get((TypeMirror)this.returnType())).addMethod(MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)this.accessibleType(this.binding.contributedType()))).addStatement("return $L", new Object[]{this.componentBindingExpressions.getDependencyExpression(this.bindingKey(), RequestKind.INSTANCE, this.componentName()).codeBlock()}).build()).build();
    }

    private String methodName() {
        if (this.requestKind().equals((Object)RequestKind.INSTANCE)) {
            return "get" + this.bindingName();
        }
        return "get" + this.bindingName() + PrivateMethodBindingExpression.dependencyKindName(this.requestKind());
    }

    private String bindingName() {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, BindingVariableNamer.name(this.binding));
    }

    private static String dependencyKindName(RequestKind kind) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, kind.name());
    }

    private TypeMirror accessibleType(TypeMirror typeMirror) {
        if (Accessibility.isTypeAccessibleFrom(typeMirror, this.componentName().packageName())) {
            return typeMirror;
        }
        if (Accessibility.isRawTypeAccessible(typeMirror, this.componentName().packageName()) && typeMirror.getKind().equals((Object)TypeKind.DECLARED)) {
            return this.types.getDeclaredType(MoreTypes.asTypeElement(typeMirror), new TypeMirror[0]);
        }
        return this.elements.getTypeElement(Object.class.getCanonicalName()).asType();
    }
}

