/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindsTypeChecker;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.RequestKinds;
import dagger.internal.codegen.ResolvedBindings;
import dagger.model.RequestKind;
import dagger.model.Scope;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class DelegateBindingExpression
extends BindingExpression {
    private final ContributionBinding binding;
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;
    private final BindsTypeChecker bindsTypeChecker;

    private DelegateBindingExpression(ResolvedBindings resolvedBindings, RequestKind requestKind, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, Elements elements) {
        super(resolvedBindings, requestKind);
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)resolvedBindings.contributionBinding());
        this.componentBindingExpressions = (ComponentBindingExpressions)Preconditions.checkNotNull((Object)componentBindingExpressions);
        this.types = (DaggerTypes)Preconditions.checkNotNull((Object)types);
        this.bindsTypeChecker = new BindsTypeChecker(types, elements);
    }

    static BindingExpression create(BindingGraph graph, BindingExpression bindingExpression, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types, Elements elements) {
        ScopeKind delegateScope;
        ResolvedBindings resolvedBindings = bindingExpression.resolvedBindings();
        ContributionBinding binding = resolvedBindings.contributionBinding();
        Binding delegateBinding = ((ResolvedBindings)graph.resolvedBindings().get((Object)((DependencyRequest)Iterables.getOnlyElement(binding.dependencies())).bindingKey())).binding();
        ScopeKind bindsScope = ScopeKind.get(binding, graph, elements);
        if (bindsScope.isSimilarOrWeakerScopeThan(delegateScope = ScopeKind.get(delegateBinding, graph, elements))) {
            RequestKind requestKind = bindingExpression.requestKind();
            return new DelegateBindingExpression(resolvedBindings, requestKind, componentBindingExpressions, types, elements);
        }
        return bindingExpression;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression delegateExpression = this.componentBindingExpressions.getDependencyExpression(((DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies())).bindingKey(), this.requestKind(), requestingClass);
        TypeMirror contributedType = this.binding.contributedType();
        switch (this.requestKind()) {
            case INSTANCE: {
                return this.instanceRequiresCast(delegateExpression, requestingClass) ? delegateExpression.castTo(contributedType) : delegateExpression;
            }
        }
        return this.castToRawTypeIfNecessary(delegateExpression, RequestKinds.requestType(this.requestKind(), contributedType, this.types));
    }

    private boolean instanceRequiresCast(Expression delegateExpression, ClassName requestingClass) {
        return !this.bindsTypeChecker.isAssignable(delegateExpression.type(), this.binding.contributedType(), this.binding.contributionType()) && Accessibility.isTypeAccessibleFrom(this.binding.contributedType(), requestingClass.packageName());
    }

    private Expression castToRawTypeIfNecessary(Expression delegateExpression, TypeMirror desiredType) {
        if (this.types.isAssignable(delegateExpression.type(), desiredType)) {
            return delegateExpression;
        }
        return delegateExpression.castTo(this.types.erasure(desiredType));
    }

    private static enum ScopeKind {
        UNSCOPED,
        RELEASABLE,
        SINGLE_CHECK,
        DOUBLE_CHECK;


        static ScopeKind get(Binding binding, BindingGraph graph, Elements elements) {
            if (!binding.scope().isPresent()) {
                return UNSCOPED;
            }
            Scope scope = binding.scope().get();
            if (graph.scopesRequiringReleasableReferenceManagers().contains((Object)scope)) {
                return RELEASABLE;
            }
            return scope.isReusable() ? SINGLE_CHECK : DOUBLE_CHECK;
        }

        boolean isSimilarOrWeakerScopeThan(ScopeKind other) {
            return this.ordinal() <= other.ordinal();
        }
    }
}

