/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class DaggerTypes
implements Types {
    private final Types types;
    private final Elements elements;

    DaggerTypes(Types types, Elements elements) {
        this.types = (Types)Preconditions.checkNotNull((Object)types);
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
    }

    DaggerTypes(ProcessingEnvironment processingEnv) {
        this(processingEnv.getTypeUtils(), processingEnv.getElementUtils());
    }

    Optional<DeclaredType> nonObjectSuperclass(DeclaredType type) {
        return Optional.ofNullable((DeclaredType)MoreTypes.nonObjectSuperclass(this.types, this.elements, type).orNull());
    }

    TypeMirror unwrapTypeOrObject(TypeMirror type) {
        DeclaredType declaredType = MoreTypes.asDeclared(type);
        TypeElement typeElement = MoreElements.asType(declaredType.asElement());
        Preconditions.checkArgument((!typeElement.getTypeParameters().isEmpty() ? 1 : 0) != 0, (String)"%s does not have a type parameter", (Object)typeElement.getQualifiedName());
        return (TypeMirror)Iterables.getOnlyElement(declaredType.getTypeArguments(), (Object)this.elements.getTypeElement(Object.class.getCanonicalName()).asType());
    }

    TypeMirror wrapType(TypeMirror type, Class<?> wrappingClass) {
        return this.types.getDeclaredType(this.elements.getTypeElement(wrappingClass.getCanonicalName()), type);
    }

    DeclaredType rewrapType(TypeMirror type, Class<?> wrappingClass) {
        List<? extends TypeMirror> typeArguments = MoreTypes.asDeclared(type).getTypeArguments();
        TypeElement wrappingType = this.elements.getTypeElement(wrappingClass.getCanonicalName());
        switch (typeArguments.size()) {
            case 0: {
                return this.types.getDeclaredType(wrappingType, new TypeMirror[0]);
            }
            case 1: {
                return this.types.getDeclaredType(wrappingType, (TypeMirror)Iterables.getOnlyElement(typeArguments));
            }
        }
        throw new IllegalArgumentException(type + " has more than 1 type argument");
    }

    @Override
    public Element asElement(TypeMirror t) {
        return this.types.asElement(t);
    }

    @Override
    public boolean isSameType(TypeMirror t1, TypeMirror t2) {
        return this.types.isSameType(t1, t2);
    }

    @Override
    public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
        return this.types.isSubtype(t1, t2);
    }

    @Override
    public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
        return this.types.isAssignable(t1, t2);
    }

    @Override
    public boolean contains(TypeMirror t1, TypeMirror t2) {
        return this.types.contains(t1, t2);
    }

    @Override
    public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
        return this.types.isSubsignature(m1, m2);
    }

    @Override
    public List<? extends TypeMirror> directSupertypes(TypeMirror t) {
        return this.types.directSupertypes(t);
    }

    @Override
    public TypeMirror erasure(TypeMirror t) {
        return this.types.erasure(t);
    }

    @Override
    public TypeElement boxedClass(PrimitiveType p) {
        return this.types.boxedClass(p);
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror t) {
        return this.types.unboxedType(t);
    }

    @Override
    public TypeMirror capture(TypeMirror t) {
        return this.types.capture(t);
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return this.types.getPrimitiveType(kind);
    }

    @Override
    public NullType getNullType() {
        return this.types.getNullType();
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        return this.types.getNoType(kind);
    }

    @Override
    public ArrayType getArrayType(TypeMirror componentType) {
        return this.types.getArrayType(componentType);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        return this.types.getWildcardType(extendsBound, superBound);
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.types.getDeclaredType(typeElem, typeArgs);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
        return this.types.getDeclaredType(containing, typeElem, typeArgs);
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType containing, Element element) {
        return this.types.asMemberOf(containing, element);
    }
}

