/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.AutoValue_CompilerOptions;
import dagger.internal.codegen.FeatureStatus;
import dagger.internal.codegen.ValidationType;
import dagger.producers.Produces;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

abstract class CompilerOptions {
    private static final String HEADER_COMPILATION = "experimental_turbine_hjar";
    static final String EXPERIMENTAL_ANDROID_MODE = "dagger.experimentalAndroidMode";
    static final String WRITE_PRODUCER_NAME_IN_TOKEN_KEY = "dagger.writeProducerNameInToken";
    static final String DISABLE_INTER_COMPONENT_SCOPE_VALIDATION_KEY = "dagger.disableInterComponentScopeValidation";
    static final String NULLABLE_VALIDATION_KEY = "dagger.nullableValidation";
    static final String PRIVATE_MEMBER_VALIDATION_TYPE_KEY = "dagger.privateMemberValidation";
    static final String STATIC_MEMBER_VALIDATION_TYPE_KEY = "dagger.staticMemberValidation";
    static final String WARN_IF_INJECTION_FACTORY_NOT_GENERATED_UPSTREAM_KEY = "dagger.warnIfInjectionFactoryNotGeneratedUpstream";
    static final String IGNORE_PRIVATE_AND_STATIC_INJECTION_FOR_COMPONENT = "dagger.ignorePrivateAndStaticInjectionForComponent";
    static final ImmutableSet<String> SUPPORTED_OPTIONS = ImmutableSet.of((Object)"dagger.experimentalAndroidMode", (Object)"experimental_turbine_hjar", (Object)"dagger.writeProducerNameInToken", (Object)"dagger.disableInterComponentScopeValidation", (Object)"dagger.nullableValidation", (Object)"dagger.privateMemberValidation", (Object[])new String[]{"dagger.staticMemberValidation", "dagger.warnIfInjectionFactoryNotGeneratedUpstream", "dagger.ignorePrivateAndStaticInjectionForComponent"});

    CompilerOptions() {
    }

    abstract boolean usesProducers();

    abstract boolean experimentalAndroidMode();

    abstract boolean writeProducerNameInToken();

    abstract Diagnostic.Kind nullableValidationKind();

    boolean doCheckForNulls() {
        return this.nullableValidationKind().equals((Object)Diagnostic.Kind.ERROR);
    }

    abstract Diagnostic.Kind privateMemberValidationKind();

    abstract Diagnostic.Kind staticMemberValidationKind();

    abstract boolean ignorePrivateAndStaticInjectionForComponent();

    abstract ValidationType scopeCycleValidationType();

    abstract boolean warnIfInjectionFactoryNotGeneratedUpstream();

    abstract boolean headerCompilation();

    static Builder builder() {
        return new AutoValue_CompilerOptions.Builder().headerCompilation(false);
    }

    static CompilerOptions create(ProcessingEnvironment processingEnv, Elements elements) {
        return CompilerOptions.builder().usesProducers(elements.getTypeElement(Produces.class.getCanonicalName()) != null).headerCompilation(processingEnv.getOptions().containsKey(HEADER_COMPILATION)).experimentalAndroidMode(CompilerOptions.experimentalAndroidMode(processingEnv).equals((Object)FeatureStatus.ENABLED)).writeProducerNameInToken(CompilerOptions.writeProducerNameInToken(processingEnv).equals((Object)FeatureStatus.ENABLED)).nullableValidationKind(CompilerOptions.nullableValidationType(processingEnv).diagnosticKind().get()).privateMemberValidationKind(CompilerOptions.privateMemberValidationType(processingEnv).diagnosticKind().get()).staticMemberValidationKind(CompilerOptions.staticMemberValidationType(processingEnv).diagnosticKind().get()).ignorePrivateAndStaticInjectionForComponent(CompilerOptions.ignorePrivateAndStaticInjectionForComponent(processingEnv).equals((Object)FeatureStatus.DISABLED)).scopeCycleValidationType(CompilerOptions.scopeValidationType(processingEnv)).warnIfInjectionFactoryNotGeneratedUpstream(CompilerOptions.warnIfInjectionFactoryNotGeneratedUpstream(processingEnv).equals((Object)FeatureStatus.ENABLED)).build();
    }

    private static FeatureStatus experimentalAndroidMode(ProcessingEnvironment processingEnv) {
        return CompilerOptions.valueOf(processingEnv, EXPERIMENTAL_ANDROID_MODE, FeatureStatus.DISABLED, EnumSet.allOf(FeatureStatus.class));
    }

    private static FeatureStatus writeProducerNameInToken(ProcessingEnvironment processingEnv) {
        return CompilerOptions.valueOf(processingEnv, WRITE_PRODUCER_NAME_IN_TOKEN_KEY, FeatureStatus.DISABLED, EnumSet.allOf(FeatureStatus.class));
    }

    private static ValidationType scopeValidationType(ProcessingEnvironment processingEnv) {
        return CompilerOptions.valueOf(processingEnv, DISABLE_INTER_COMPONENT_SCOPE_VALIDATION_KEY, ValidationType.ERROR, EnumSet.allOf(ValidationType.class));
    }

    private static ValidationType nullableValidationType(ProcessingEnvironment processingEnv) {
        return CompilerOptions.valueOf(processingEnv, NULLABLE_VALIDATION_KEY, ValidationType.ERROR, EnumSet.of(ValidationType.ERROR, ValidationType.WARNING));
    }

    private static ValidationType privateMemberValidationType(ProcessingEnvironment processingEnv) {
        return CompilerOptions.valueOf(processingEnv, PRIVATE_MEMBER_VALIDATION_TYPE_KEY, ValidationType.ERROR, EnumSet.of(ValidationType.ERROR, ValidationType.WARNING));
    }

    private static ValidationType staticMemberValidationType(ProcessingEnvironment processingEnv) {
        return CompilerOptions.valueOf(processingEnv, STATIC_MEMBER_VALIDATION_TYPE_KEY, ValidationType.ERROR, EnumSet.of(ValidationType.ERROR, ValidationType.WARNING));
    }

    private static FeatureStatus ignorePrivateAndStaticInjectionForComponent(ProcessingEnvironment processingEnv) {
        return CompilerOptions.valueOf(processingEnv, IGNORE_PRIVATE_AND_STATIC_INJECTION_FOR_COMPONENT, FeatureStatus.DISABLED, EnumSet.allOf(FeatureStatus.class));
    }

    private static FeatureStatus warnIfInjectionFactoryNotGeneratedUpstream(ProcessingEnvironment processingEnv) {
        return CompilerOptions.valueOf(processingEnv, WARN_IF_INJECTION_FACTORY_NOT_GENERATED_UPSTREAM_KEY, FeatureStatus.DISABLED, EnumSet.allOf(FeatureStatus.class));
    }

    private static <T extends Enum<T>> T valueOf(ProcessingEnvironment processingEnv, String key, T defaultValue, Set<T> validValues) {
        Map<String, String> options = processingEnv.getOptions();
        if (options.containsKey(key)) {
            try {
                T type = Enum.valueOf(defaultValue.getDeclaringClass(), Ascii.toUpperCase((String)options.get(key)));
                if (!validValues.contains(type)) {
                    throw new IllegalArgumentException();
                }
                return type;
            }
            catch (IllegalArgumentException e) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Processor option -A" + key + " may only have the values " + validValues + " (case insensitive), found: " + options.get(key));
            }
        }
        return defaultValue;
    }

    static interface Builder {
        public Builder usesProducers(boolean var1);

        public Builder headerCompilation(boolean var1);

        public Builder experimentalAndroidMode(boolean var1);

        public Builder writeProducerNameInToken(boolean var1);

        public Builder nullableValidationKind(Diagnostic.Kind var1);

        public Builder privateMemberValidationKind(Diagnostic.Kind var1);

        public Builder staticMemberValidationKind(Diagnostic.Kind var1);

        public Builder ignorePrivateAndStaticInjectionForComponent(boolean var1);

        public Builder scopeCycleValidationType(ValidationType var1);

        public Builder warnIfInjectionFactoryNotGeneratedUpstream(boolean var1);

        public CompilerOptions build();
    }
}

