/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;

final class AnyBindingMethodValidator {
    private final ImmutableMap<Class<? extends Annotation>, BindingMethodValidator> validators;
    private final Map<ExecutableElement, ValidationReport<ExecutableElement>> reports = new HashMap<ExecutableElement, ValidationReport<ExecutableElement>>();

    AnyBindingMethodValidator(BindingMethodValidator ... validators) {
        this.validators = Maps.uniqueIndex(Arrays.asList(validators), BindingMethodValidator::methodAnnotation);
    }

    ImmutableSet<Class<? extends Annotation>> methodAnnotations() {
        return this.validators.keySet();
    }

    boolean isBindingMethod(ExecutableElement method) {
        return DaggerElements.isAnyAnnotationPresent(method, this.methodAnnotations());
    }

    ValidationReport<ExecutableElement> validate(ExecutableElement method) {
        return Util.reentrantComputeIfAbsent(this.reports, method, this::validateUncached);
    }

    boolean wasAlreadyValidated(ExecutableElement method) {
        return this.reports.containsKey(method);
    }

    private ValidationReport<ExecutableElement> validateUncached(ExecutableElement method) {
        ValidationReport.Builder<ExecutableElement> report = ValidationReport.about(method);
        ImmutableSet bindingMethodAnnotations = this.methodAnnotations().stream().filter(annotation -> MoreElements.isAnnotationPresent(method, annotation)).collect(DaggerStreams.toImmutableSet());
        switch (bindingMethodAnnotations.size()) {
            case 0: {
                throw new IllegalArgumentException(String.format("%s has no binding method annotation", method));
            }
            case 1: {
                report.addSubreport(((BindingMethodValidator)this.validators.get(Iterables.getOnlyElement(bindingMethodAnnotations))).validate(method));
                break;
            }
            default: {
                report.addError(ErrorMessages.tooManyBindingMethodAnnotations(method, this.methodAnnotations()), method);
            }
        }
        return report.build();
    }
}

