/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkDependency;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.Proxies;
import dagger.internal.codegen.RequestFulfillment;
import dagger.internal.codegen.RequestFulfillmentRegistry;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.TypeNames;
import dagger.shaded.auto.common.MoreElements;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class SimpleMethodRequestFulfillment
extends RequestFulfillment {
    private final ProvisionBinding provisionBinding;
    private final RequestFulfillment providerDelegate;
    private final RequestFulfillmentRegistry registry;

    SimpleMethodRequestFulfillment(BindingKey bindingKey, ProvisionBinding provisionBinding, RequestFulfillment providerDelegate, RequestFulfillmentRegistry registry) {
        super(bindingKey);
        Preconditions.checkArgument((boolean)provisionBinding.implicitDependencies().isEmpty(), (Object)"framework deps are not currently supported");
        Preconditions.checkArgument((!provisionBinding.scope().isPresent() ? 1 : 0) != 0);
        Preconditions.checkArgument((!provisionBinding.requiresModuleInstance() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)provisionBinding.bindingElement().isPresent());
        this.provisionBinding = provisionBinding;
        this.providerDelegate = providerDelegate;
        this.registry = registry;
    }

    @Override
    CodeBlock getSnippetForDependencyRequest(DependencyRequest request, ClassName requestingClass) {
        switch (request.kind()) {
            case INSTANCE: {
                return this.invokeMethodOrProxy(requestingClass);
            }
            case FUTURE: {
                return CodeBlock.of((String)"$T.immediateFuture($L)", (Object[])new Object[]{Futures.class, this.invokeMethodOrProxy(requestingClass)});
            }
        }
        return this.providerDelegate.getSnippetForDependencyRequest(request, requestingClass);
    }

    @Override
    CodeBlock getSnippetForFrameworkDependency(FrameworkDependency frameworkDependency, ClassName requestingClass) {
        return this.providerDelegate.getSnippetForFrameworkDependency(frameworkDependency, requestingClass);
    }

    private CodeBlock invokeMethodOrProxy(ClassName requestingClass) {
        ExecutableElement bindingElement = MoreElements.asExecutable(this.provisionBinding.bindingElement().get());
        return Proxies.requiresProxyAccess(bindingElement, requestingClass.packageName()) ? this.invokeProxyMethod(requestingClass) : this.invokeMethod(requestingClass);
    }

    private CodeBlock invokeMethod(ClassName requestingClass) {
        CodeBlock parametersCodeBlock = CodeBlocks.makeParametersCodeBlock(this.provisionBinding.explicitDependencies().stream().map(request -> {
            CodeBlock snippet = this.getDependencySnippet(requestingClass, (DependencyRequest)request);
            TypeMirror requestElementType = request.requestElement().get().asType();
            return Accessibility.isTypeAccessibleFrom(requestElementType, requestingClass.packageName()) ? snippet : CodeBlock.of((String)"($T) $L", (Object[])new Object[]{TypeNames.rawTypeName(TypeName.get((TypeMirror)requestElementType)), snippet});
        }).collect(Collectors.toList()));
        ExecutableElement method = MoreElements.asExecutable(this.provisionBinding.bindingElement().get());
        switch (method.getKind()) {
            case CONSTRUCTOR: {
                return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{this.provisionBinding.key().type(), parametersCodeBlock});
            }
            case METHOD: {
                Preconditions.checkState((boolean)method.getModifiers().contains((Object)Modifier.STATIC));
                return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{this.provisionBinding.bindingTypeElement().get(), method.getSimpleName(), parametersCodeBlock});
            }
        }
        throw new IllegalStateException();
    }

    private CodeBlock invokeProxyMethod(ClassName requestingClass) {
        return CodeBlock.of((String)"$T.$L($L)", (Object[])new Object[]{SourceFiles.generatedClassNameForBinding(this.provisionBinding), Proxies.proxyName(MoreElements.asExecutable(this.provisionBinding.bindingElement().get())), this.provisionBinding.explicitDependencies().stream().map(request -> this.getDependencySnippet(requestingClass, (DependencyRequest)request)).collect(Collectors.collectingAndThen(Collectors.toList(), CodeBlocks::makeParametersCodeBlock))});
    }

    private CodeBlock getDependencySnippet(ClassName requestingClass, DependencyRequest request) {
        return this.registry.getRequestFulfillment(request.bindingKey()).getSnippetForDependencyRequest(request, requestingClass);
    }
}

