/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentProvider;
import com.google.errorprone.annotations.ForOverride;
import dagger.android.AndroidInjector;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.HasActivityInjector;
import dagger.android.HasBroadcastReceiverInjector;
import dagger.android.HasContentProviderInjector;
import dagger.android.HasFragmentInjector;
import dagger.android.HasServiceInjector;
import javax.inject.Inject;

public abstract class DaggerApplication
extends Application
implements HasActivityInjector,
HasFragmentInjector,
HasServiceInjector,
HasBroadcastReceiverInjector,
HasContentProviderInjector {
    @Inject
    DispatchingAndroidInjector<Activity> activityInjector;
    @Inject
    DispatchingAndroidInjector<BroadcastReceiver> broadcastReceiverInjector;
    @Inject
    DispatchingAndroidInjector<Fragment> fragmentInjector;
    @Inject
    DispatchingAndroidInjector<Service> serviceInjector;
    @Inject
    DispatchingAndroidInjector<ContentProvider> contentProviderInjector;
    private volatile boolean needToInject = true;

    public void onCreate() {
        super.onCreate();
        this.injectIfNecessary();
    }

    @ForOverride
    protected abstract AndroidInjector<? extends DaggerApplication> applicationInjector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectIfNecessary() {
        if (this.needToInject) {
            DaggerApplication daggerApplication = this;
            synchronized (daggerApplication) {
                if (this.needToInject) {
                    AndroidInjector<? extends DaggerApplication> applicationInjector = this.applicationInjector();
                    applicationInjector.inject(this);
                    if (this.needToInject) {
                        throw new IllegalStateException("The AndroidInjector returned from applicationInjector() did not inject the DaggerApplication");
                    }
                }
            }
        }
    }

    @Inject
    void setInjected() {
        this.needToInject = false;
    }

    public DispatchingAndroidInjector<Activity> activityInjector() {
        return this.activityInjector;
    }

    public DispatchingAndroidInjector<Fragment> fragmentInjector() {
        return this.fragmentInjector;
    }

    public DispatchingAndroidInjector<BroadcastReceiver> broadcastReceiverInjector() {
        return this.broadcastReceiverInjector;
    }

    public DispatchingAndroidInjector<Service> serviceInjector() {
        return this.serviceInjector;
    }

    @Override
    public AndroidInjector<ContentProvider> contentProviderInjector() {
        this.injectIfNecessary();
        return this.contentProviderInjector;
    }
}

