/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import dagger.android.AndroidInjector;
import dagger.internal.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;

public final class DispatchingAndroidInjector<T> {
    private static final String NO_SUPERTYPES_BOUND_FORMAT = "No injector factory bound for Class<%s>";
    private static final String SUPERTYPES_BOUND_FORMAT = "No injector factory bound for Class<%1$s>. Injector factories were bound for supertypes of %1$s: %2$s. Did you mean to bind an injector factory for the subtype?";
    private final Map<Class<? extends T>, Provider<AndroidInjector.Factory<? extends T>>> injectorFactories;

    @Inject
    DispatchingAndroidInjector(Map<Class<? extends T>, Provider<AndroidInjector.Factory<? extends T>>> map) {
        this.injectorFactories = map;
    }

    public boolean maybeInject(T t) {
        Provider<AndroidInjector.Factory<? extends T>> provider = this.injectorFactories.get(t.getClass());
        if (provider == null) {
            return false;
        }
        AndroidInjector.Factory factory = (AndroidInjector.Factory)provider.get();
        try {
            AndroidInjector androidInjector = (AndroidInjector)Preconditions.checkNotNull(factory.create(t), (String)"%s.create(I) should not return null.", (Object)factory.getClass().getCanonicalName());
            androidInjector.inject(t);
            return true;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInjectorBindingException(String.format("%s does not implement AndroidInjector.Factory<%s>", factory.getClass().getCanonicalName(), t.getClass().getCanonicalName()), classCastException);
        }
    }

    public void inject(T t) {
        boolean bl = this.maybeInject(t);
        if (!bl) {
            throw new IllegalArgumentException(this.errorMessageSuggestions(t));
        }
    }

    private String errorMessageSuggestions(T t) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Class<T> clazz : this.injectorFactories.keySet()) {
            if (!clazz.isInstance(t)) continue;
            arrayList.add(clazz.getCanonicalName());
        }
        Collections.sort(arrayList);
        return String.format(arrayList.isEmpty() ? NO_SUPERTYPES_BOUND_FORMAT : SUPERTYPES_BOUND_FORMAT, t.getClass().getCanonicalName(), arrayList);
    }

    public static final class InvalidInjectorBindingException
    extends RuntimeException {
        InvalidInjectorBindingException(String string, ClassCastException classCastException) {
            super(string, classCastException);
        }
    }
}

